/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.cnri.util.StreamUtil;

public class JsonParameterServletReq
extends HttpServletRequestWrapper {
    JsonObject json;

    public JsonParameterServletReq(HttpServletRequest servletReq) throws IOException, JsonParseException {
        super(servletReq);
        String entity = StreamUtil.readFully((Reader)servletReq.getReader());
        if (entity.isEmpty()) {
            return;
        }
        JsonElement jsonElement = JsonParser.parseString((String)entity);
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Expected JSON object");
        }
        this.json = jsonElement.getAsJsonObject();
    }

    public String getParameter(String name) {
        String res = super.getParameter(name);
        if (res != null) {
            return res;
        }
        if (this.json == null) {
            return null;
        }
        res = this.getStringProperty(name);
        return res;
    }

    private String getStringProperty(String name) {
        JsonElement property = this.json.get(name);
        if (property == null) {
            return null;
        }
        if (property.isJsonArray()) {
            JsonArray array = property.getAsJsonArray();
            if (array.size() > 0) {
                return array.get(0).getAsString();
            }
            return null;
        }
        return property.getAsString();
    }

    public Enumeration<String> getParameterNames() {
        Enumeration res = super.getParameterNames();
        if (this.json == null) {
            return res;
        }
        HashSet<String> set = new HashSet<String>();
        while (res.hasMoreElements()) {
            set.add((String)res.nextElement());
        }
        for (Map.Entry entry : this.json.entrySet()) {
            set.add((String)entry.getKey());
        }
        return Collections.enumeration(set);
    }

    public String[] getParameterValues(String name) {
        String[] origRes = super.getParameterValues(name);
        if (this.json == null) {
            return origRes;
        }
        String[] props = this.getMultipleStringProperty(name);
        if (props == null) {
            return origRes;
        }
        if (origRes == null) {
            return props;
        }
        String[] augmentedRes = new String[origRes.length + props.length];
        System.arraycopy(origRes, 0, augmentedRes, 0, origRes.length);
        System.arraycopy(props, 0, augmentedRes, origRes.length, props.length);
        return augmentedRes;
    }

    private String[] getMultipleStringProperty(String name) {
        JsonElement property = this.json.get(name);
        if (property == null) {
            return null;
        }
        return this.stringArrayOfJsonElement(property);
    }

    private String[] stringArrayOfJsonElement(JsonElement property) {
        if (property.isJsonArray()) {
            JsonArray array = property.getAsJsonArray();
            if (array.size() > 0) {
                String[] res = new String[array.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = array.get(i).getAsString();
                }
                return res;
            }
            return null;
        }
        return new String[]{property.getAsString()};
    }

    public Map<String, String[]> getParameterMap() {
        return new AbstractMap<String, String[]>(){
            Set<Map.Entry<String, String[]>> entrySet;

            @Override
            public Set<Map.Entry<String, String[]>> entrySet() {
                if (this.entrySet != null) {
                    return this.entrySet;
                }
                Enumeration queryNames = JsonParameterServletReq.super.getParameterNames();
                HashSet<String> keySet = new HashSet<String>();
                this.entrySet = new HashSet<Map.Entry<String, String[]>>();
                while (queryNames.hasMoreElements()) {
                    String name = (String)queryNames.nextElement();
                    keySet.add(name);
                    this.entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(name, JsonParameterServletReq.this.getParameterValues(name)));
                }
                if (JsonParameterServletReq.this.json == null) {
                    return this.entrySet;
                }
                for (Map.Entry entry : JsonParameterServletReq.this.json.entrySet()) {
                    String name = (String)entry.getKey();
                    if (keySet.contains(name)) continue;
                    keySet.add(name);
                    this.entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(name, JsonParameterServletReq.this.stringArrayOfJsonElement((JsonElement)entry.getValue())));
                }
                return this.entrySet;
            }
        };
    }
}

