/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import net.handle.server.servletcontainer.servlets.ListCallback;
import net.handle.server.servletcontainer.support.LoggingResponseMessageCallbackWrapper;

public class HandleJsonRestApiServlet
extends BaseHandleRequestProcessingServlet {
    public HandleJsonRestApiServlet() {
        this.allowString = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS";
    }

    private static byte[][] getTypes(HttpServletRequest servletReq) {
        String[] typeStrings = servletReq.getParameterValues("type");
        byte[][] types = null;
        if (typeStrings != null && typeStrings.length > 0) {
            types = new byte[typeStrings.length][];
            for (int i = 0; i < typeStrings.length; ++i) {
                types[i] = Util.encodeString(typeStrings[i]);
            }
        }
        return types;
    }

    @Override
    protected void doGet(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        String handle = HandleJsonRestApiServlet.getPath(servletReq);
        if (handle.isEmpty()) {
            String prefix = servletReq.getParameter("prefix");
            if (prefix != null) {
                this.listHandles(prefix, servletReq, servletResp);
            } else {
                this.emptyHandleError(servletReq, servletResp);
            }
        } else {
            this.doOneHandleGet(servletReq, servletResp);
        }
    }

    private void emptyHandleError(HttpServletRequest servletReq, HttpServletResponse servletResp) throws IOException {
        ErrorResponse resp = new ErrorResponse(0, 102, Util.encodeString("Empty handle invalid"));
        this.processResponse(servletReq, servletResp, null, resp);
    }

    private void doOneHandleGet(HttpServletRequest servletReq, HttpServletResponse servletResp) throws IOException {
        AbstractResponse resp;
        ResolutionRequest req;
        try {
            req = HandleJsonRestApiServlet.getResolutionRequest(servletReq);
            resp = this.processRequest(servletReq, req);
        }
        catch (Exception e) {
            req = null;
            resp = HandleJsonRestApiServlet.errorResponseFromException(e);
        }
        this.processResponse(servletReq, servletResp, req, resp);
    }

    private static ResolutionRequest getResolutionRequest(HttpServletRequest servletReq) throws Exception {
        String handle = HandleJsonRestApiServlet.getPath(servletReq);
        byte[][] types = HandleJsonRestApiServlet.getTypes(servletReq);
        int[] indexes = HandleJsonRestApiServlet.getIndexes(servletReq);
        AuthenticationInfo authInfo = HandleJsonRestApiServlet.getAuthenticationInfo(servletReq);
        ResolutionRequest resReq = new ResolutionRequest(Util.encodeString(handle), types, indexes, authInfo);
        resReq.ignoreRestrictedValues = servletReq.getParameter("publicOnly") != null ? HandleJsonRestApiServlet.getBooleanParameter(servletReq, "publicOnly") : authInfo == null;
        resReq.authoritative = HandleJsonRestApiServlet.getBooleanParameter(servletReq, "auth");
        return resReq;
    }

    @Override
    protected void doPut(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        AbstractResponse resp;
        AbstractRequest req;
        try {
            this.checkContentType(servletReq);
            req = this.getCreateOrAddRequest(servletReq);
            resp = this.processRequest(servletReq, req);
        }
        catch (Exception e) {
            req = null;
            resp = HandleJsonRestApiServlet.errorResponseFromException(e);
        }
        this.processResponse(servletReq, servletResp, req, resp);
    }

    private void checkContentType(HttpServletRequest servletReq) throws Exception {
        if (!HandleJsonRestApiServlet.hasJsonEntity(servletReq)) {
            throw new Exception("Unsupported media type " + servletReq.getContentType());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractRequest getCreateOrAddRequest(HttpServletRequest servletReq) throws Exception {
        void var7_10;
        HandleValue[] values;
        JsonElement valuesJson;
        String handle = HandleJsonRestApiServlet.getPath(servletReq);
        int[] indexes = null;
        boolean indexesVarious = "various".equals(servletReq.getParameter("index"));
        if (!indexesVarious) {
            indexes = HandleJsonRestApiServlet.getIndexes(servletReq);
        }
        if ((valuesJson = JsonParser.parseReader((Reader)servletReq.getReader())).isJsonArray()) {
            values = (HandleValue[])GsonUtility.getGson().fromJson(valuesJson, HandleValue[].class);
        } else {
            if (!valuesJson.isJsonObject()) throw new Exception("Invalid JSON in PUT request");
            JsonObject jsonObject = valuesJson.getAsJsonObject();
            if (jsonObject.has("values")) {
                this.throwIfHandlesDoNotMatch(handle, valuesJson);
                values = (HandleValue[])GsonUtility.getGson().fromJson(jsonObject.get("values"), HandleValue[].class);
            } else {
                if (!HandleJsonRestApiServlet.looksLikeHandleValue(jsonObject)) throw new Exception("Invalid JSON in PUT request");
                HandleValue value = (HandleValue)GsonUtility.getGson().fromJson((JsonElement)jsonObject, HandleValue.class);
                values = new HandleValue[]{value};
            }
        }
        if (values == null) {
            values = new HandleValue[]{};
        }
        if (!indexesVarious && indexes == null) {
            CreateHandleRequest createHandleRequest = new CreateHandleRequest(Util.encodeString(handle), values, HandleJsonRestApiServlet.getAuthenticationInfo(servletReq));
        } else {
            if (!indexesVarious) {
                HandleJsonRestApiServlet.throwIfIndexesDoNotMatch(indexes, values);
            }
            AddValueRequest addValueRequest = new AddValueRequest(Util.encodeString(handle), values, HandleJsonRestApiServlet.getAuthenticationInfo(servletReq));
        }
        String overwriteParam = servletReq.getParameter("overwrite");
        var7_10.overwriteWhenExists = overwriteParam == null ? "PUT".equals(servletReq.getMethod()) : Boolean.parseBoolean(overwriteParam);
        String mintNewSuffix = servletReq.getParameter("mintNewSuffix");
        if (mintNewSuffix == null) return var7_10;
        var7_10.mintNewSuffix = Boolean.parseBoolean(mintNewSuffix);
        return var7_10;
    }

    static boolean looksLikeHandleValue(JsonObject valueJsonObject) {
        if (!valueJsonObject.has("index")) {
            return false;
        }
        if (!valueJsonObject.has("type")) {
            return false;
        }
        return valueJsonObject.has("data");
    }

    private void throwIfHandlesDoNotMatch(String handle, JsonElement valuesJson) throws Exception {
        JsonElement handleFromJson = valuesJson.getAsJsonObject().get("handle");
        if (handleFromJson != null && !this.handleMatches(handle, handleFromJson.getAsString())) {
            throw new Exception("Mismatched handle in PUT request");
        }
    }

    private static void throwIfIndexesDoNotMatch(int[] indexes, HandleValue[] values) throws Exception {
        HashSet<Integer> indexesFromValues = new HashSet<Integer>();
        for (HandleValue value : values) {
            indexesFromValues.add(value.getIndex());
        }
        HashSet<Integer> indexesFromQuery = new HashSet<Integer>();
        for (int index : indexes) {
            indexesFromQuery.add(index);
        }
        if (indexesFromQuery.size() != indexesFromValues.size() || indexesFromQuery.retainAll(indexesFromValues)) {
            throw new Exception("Mismatched indexes in PUT request");
        }
    }

    private boolean handleMatches(String h1, String h2) {
        if (this.caseSensitive) {
            return Util.equalsPrefixCI(Util.encodeString(h1), Util.encodeString(h2));
        }
        return Util.equalsCI(Util.encodeString(h1), Util.encodeString(h2));
    }

    @Override
    protected void doDelete(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        AbstractResponse resp;
        AbstractRequest req;
        try {
            req = HandleJsonRestApiServlet.getDeleteRequest(servletReq);
            resp = this.processRequest(servletReq, req);
        }
        catch (Exception e) {
            req = null;
            resp = HandleJsonRestApiServlet.errorResponseFromException(e);
        }
        this.processResponse(servletReq, servletResp, req, resp);
    }

    private static AbstractRequest getDeleteRequest(HttpServletRequest servletReq) throws Exception {
        String handle = HandleJsonRestApiServlet.getPath(servletReq);
        int[] indexes = HandleJsonRestApiServlet.getIndexes(servletReq);
        AbstractRequest req = indexes == null ? new DeleteHandleRequest(Util.encodeString(handle), HandleJsonRestApiServlet.getAuthenticationInfo(servletReq)) : new RemoveValueRequest(Util.encodeString(handle), indexes, HandleJsonRestApiServlet.getAuthenticationInfo(servletReq));
        return req;
    }

    private void listHandles(String prefix, HttpServletRequest servletReq, HttpServletResponse servletResp) throws IOException {
        try {
            ListHandlesRequest listReq = HandleJsonRestApiServlet.getListHandlesRequest(prefix, servletReq);
            ListCallback listCallback = new ListCallback();
            listCallback.page = HandleJsonRestApiServlet.getIntegerParameter(servletReq, "page", -1);
            listCallback.pageSize = HandleJsonRestApiServlet.getIntegerParameter(servletReq, "pageSize", -1);
            listReq.certify = HandleJsonRestApiServlet.getBooleanParameter(servletReq, "cert");
            ResponseMessageCallback callbackWrapper = listCallback;
            if (this.handleServer != null) {
                callbackWrapper = new LoggingResponseMessageCallbackWrapper(listCallback, this.handleServer, this.handleServer.logHttpAccesses(), listReq, HandleJsonRestApiServlet.getRemoteInetAddress(servletReq), "HDLApi");
            }
            try {
                this.requestHandler.processRequest(listReq, HandleJsonRestApiServlet.getRemoteInetAddress(servletReq), callbackWrapper);
            }
            catch (HandleException e) {
                listCallback.unexpectedResponse = HandleException.toErrorResponse(listReq, e);
            }
            if (listCallback.unexpectedResponse != null) {
                this.processResponse(servletReq, servletResp, listReq, listCallback.unexpectedResponse);
            } else {
                listCallback.processListHandlesResponse(servletReq, servletResp, listReq, listCallback.handles, listCallback.totalCount);
            }
        }
        catch (IllegalArgumentException e) {
            this.processResponse(servletReq, servletResp, null, HandleJsonRestApiServlet.errorResponseFromException(e));
        }
    }

    private static ListHandlesRequest getListHandlesRequest(String prefix, HttpServletRequest servletReq) throws IllegalArgumentException, NumberFormatException {
        return new ListHandlesRequest(Util.encodeString(prefix), HandleJsonRestApiServlet.getAuthenticationInfo(servletReq));
    }
}

