/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.util.ServletUtil;
import net.cnri.util.StringUtils;
import net.handle.apps.servlet_proxy.HDLProxy;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.servlets.JsonParameterServletReq;
import net.handle.server.servletcontainer.support.PreAuthenticatedRequestProcessor;

public class BaseHandleRequestProcessingServlet
extends HttpServlet {
    HandleServerInterface handleServer;
    RequestProcessor requestHandler;
    boolean caseSensitive;
    protected String allowString = "TRACE, OPTIONS";

    public void init() throws ServletException {
        this.handleServer = (HandleServerInterface)this.getServletContext().getAttribute("net.handle.server.HandleServer");
        if (this.handleServer == null) {
            this.requestHandler = (HandleResolver)this.getServletContext().getAttribute(HandleResolver.class.getName());
            if (this.requestHandler == null) {
                this.requestHandler = new HandleResolver();
            }
            this.caseSensitive = true;
        } else {
            this.requestHandler = new PreAuthenticatedRequestProcessor(this.handleServer, null);
            this.caseSensitive = this.handleServer.isCaseSensitive();
        }
    }

    protected static String getPath(HttpServletRequest servletReq) {
        String pathInfo = ServletUtil.pathExcluding((String)servletReq.getRequestURI(), (String)(servletReq.getContextPath() + servletReq.getServletPath()));
        if ((pathInfo = StringUtils.decodeURLIgnorePlus((String)pathInfo)).startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }

    protected static int[] getIndexes(HttpServletRequest servletReq) throws NumberFormatException {
        String[] indexStrings = servletReq.getParameterValues("index");
        int[] indexes = null;
        if (indexStrings != null && indexStrings.length > 0) {
            indexes = new int[indexStrings.length];
            for (int i = 0; i < indexStrings.length; ++i) {
                indexes[i] = Integer.parseInt(indexStrings[i]);
                continue;
            }
        }
        return indexes;
    }

    protected static AuthenticationInfo getAuthenticationInfo(HttpServletRequest servletReq) {
        return (AuthenticationInfo)servletReq.getAttribute(AuthenticationInfo.class.getName());
    }

    protected static InetAddress getRemoteInetAddress(HttpServletRequest servletReq) {
        try {
            HDLProxy hdlProxy = (HDLProxy)((Object)servletReq.getServletContext().getAttribute(HDLProxy.class.getName()));
            if (hdlProxy == null) {
                return InetAddress.getByName(servletReq.getRemoteAddr());
            }
            return hdlProxy.getRemoteInetAddress(servletReq);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static Gson getGsonForRequest(HttpServletRequest servletReq) {
        Gson gson = BaseHandleRequestProcessingServlet.getBooleanParameter(servletReq, "pretty") ? GsonUtility.getNewGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create() : GsonUtility.getGson();
        return gson;
    }

    protected static boolean getBooleanParameter(HttpServletRequest servletReq, String param) {
        String value = servletReq.getParameter(param);
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        return "true".equalsIgnoreCase(value);
    }

    protected AbstractResponse processRequest(HttpServletRequest servletReq, AbstractRequest handleReq) {
        handleReq.certify = BaseHandleRequestProcessingServlet.getBooleanParameter(servletReq, "cert");
        handleReq.doNotRefer = BaseHandleRequestProcessingServlet.getBooleanParameter(servletReq, "doNotRefer");
        try {
            return this.requestHandler.processRequest(handleReq, BaseHandleRequestProcessingServlet.getRemoteInetAddress(servletReq));
        }
        catch (HandleException e) {
            return HandleException.toErrorResponse(handleReq, e);
        }
    }

    protected static AbstractResponse errorResponseFromException(Exception e) {
        String message = e.toString();
        ErrorResponse resp = new ErrorResponse(0, 4, Util.encodeString(message));
        return resp;
    }

    protected void processResponse(HttpServletRequest servletReq, HttpServletResponse servletResp, AbstractRequest handleReq, AbstractResponse handleResp) throws IOException {
        BaseHandleRequestProcessingServlet.processResponse(servletReq, servletResp, BaseHandleRequestProcessingServlet.statusCodeFromResponse(handleResp), GsonUtility.serializeResponseToRequest(handleReq, handleResp));
        this.logAccess(servletReq, handleReq, handleResp);
    }

    private void logAccess(HttpServletRequest servletReq, AbstractRequest currentHdlRequest, AbstractResponse response) {
        if (this.handleServer != null) {
            if (!this.handleServer.logHttpAccesses()) {
                return;
            }
            long recvTime = (Long)servletReq.getAttribute("recvTime");
            long respTime = System.currentTimeMillis() - recvTime;
            this.handleServer.logAccess("HTTP:HDLApi", BaseHandleRequestProcessingServlet.getRemoteInetAddress(servletReq), response.opCode, response.responseCode, Util.getAccessLogString(currentHdlRequest, response), respTime);
        } else {
            HDLProxy hdlProxy = (HDLProxy)((Object)this.getServletContext().getAttribute(HDLProxy.class.getName()));
            if (hdlProxy == null) {
                return;
            }
            long responseTime = 0L;
            try {
                long recvTime = (Long)servletReq.getAttribute("recvTime");
                responseTime = System.currentTimeMillis() - recvTime;
            }
            catch (Exception recvTime) {
                // empty catch block
            }
            String referer = servletReq.getHeader("Referer");
            if (referer == null) {
                referer = "";
            }
            String userAgent = servletReq.getHeader("user-agent");
            byte[] handle = currentHdlRequest == null ? Common.BLANK_HANDLE : currentHdlRequest.handle;
            hdlProxy.logAccess("HTTP:HDLApi", response.opCode, response.responseCode, Util.decodeString(handle), hdlProxy.getRemoteAddr(servletReq), referer, userAgent, responseTime, null, null);
        }
    }

    static String scrubCallbackParameter(String callback) {
        StringBuilder sb = null;
        for (int i = 0; i < callback.length(); ++i) {
            char ch = callback.charAt(i);
            if (ch == '_' || ch == '$' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || i > 0 && ch >= '0' && ch <= '9' || ch >= '\u00a0') continue;
            if (sb == null) {
                sb = new StringBuilder(callback);
            }
            sb.setCharAt(i, '_');
        }
        if (sb == null) {
            return callback;
        }
        return sb.toString();
    }

    public static void processResponse(HttpServletRequest servletReq, HttpServletResponse servletResp, int statusCode, JsonElement obj) throws IOException {
        String callback = servletReq.getParameter("callback");
        if (callback != null) {
            callback = BaseHandleRequestProcessingServlet.scrubCallbackParameter(callback);
        }
        servletResp.setStatus(statusCode);
        if (callback == null) {
            servletResp.setContentType("application/json");
        } else {
            servletResp.setContentType("application/javascript");
        }
        servletResp.setCharacterEncoding("UTF-8");
        if (callback != null) {
            servletResp.getWriter().append(callback).append("(");
        }
        Gson gson = BaseHandleRequestProcessingServlet.getGsonForRequest(servletReq);
        gson.toJson(obj, (Appendable)servletResp.getWriter());
        if (callback != null) {
            servletResp.getWriter().append(");");
        }
    }

    public static int statusCodeFromResponse(AbstractResponse resp) {
        switch (resp.responseCode) {
            case 1: {
                if (!(resp.overwriteWhenExists || resp.opCode != 100 && resp.opCode != 102)) {
                    return 201;
                }
                return 200;
            }
            case 200: {
                if (resp.opCode == 1) {
                    return 200;
                }
                return 400;
            }
            case 302: 
            case 303: {
                return 300;
            }
            case 100: {
                return 404;
            }
            case 101: 
            case 201: {
                return 409;
            }
            case 4: 
            case 102: 
            case 202: {
                return 400;
            }
            case 301: {
                return 400;
            }
            case 5: {
                return 501;
            }
            case 3: 
            case 7: {
                return 503;
            }
            case 402: {
                return 401;
            }
            case 400: 
            case 401: 
            case 403: 
            case 404: {
                return 403;
            }
        }
        return 500;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("recvTime", (Object)System.currentTimeMillis());
        String method = req.getMethod();
        if ("GET".equals(method)) {
            this.doGet(req, resp);
        } else if ("HEAD".equals(method)) {
            this.doHead(req, resp);
        } else if ("POST".equals(method)) {
            this.doPost(req, resp);
        } else if ("PUT".equals(method)) {
            this.doPut(req, resp);
        } else if ("DELETE".equals(method)) {
            this.doDelete(req, resp);
        } else if ("OPTIONS".equals(method)) {
            this.doOptions(req, resp);
        } else if ("TRACE".equals(method)) {
            this.doTrace(req, resp);
        } else {
            JsonObject json = new JsonObject();
            json.addProperty("responseCode", (Number)4);
            json.addProperty("message", "Unknown method " + method);
            BaseHandleRequestProcessingServlet.processResponse(req, resp, 501, (JsonElement)json);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", this.allowString);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.methodNotAllowed(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.methodNotAllowed(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.methodNotAllowed(req, resp);
    }

    private void methodNotAllowed(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("responseCode", (Number)4);
        json.addProperty("message", "Unknown HTTP API endpoint " + req.getMethod() + " " + req.getRequestURI());
        BaseHandleRequestProcessingServlet.processResponse(req, resp, 405, (JsonElement)json);
    }

    protected void doPost(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        if (BaseHandleRequestProcessingServlet.hasJsonEntity(servletReq)) {
            try {
                this.doGet((HttpServletRequest)new JsonParameterServletReq(servletReq), servletResp);
            }
            catch (JsonParseException e) {
                this.processResponse(servletReq, servletResp, null, BaseHandleRequestProcessingServlet.errorResponseFromException((Exception)((Object)e)));
            }
        } else {
            this.doGet(servletReq, servletResp);
        }
    }

    protected static boolean hasJsonEntity(HttpServletRequest servletReq) {
        String contentType = servletReq.getContentType();
        if (contentType == null) {
            return false;
        }
        if ((contentType = contentType.trim().toLowerCase()).equals("application/json")) {
            return true;
        }
        return contentType.matches("^application/json\\s*;.*");
    }

    static int getIntegerParameter(HttpServletRequest servletReq, String paramName, int defaultValue) throws NumberFormatException {
        String paramValue = servletReq.getParameter(paramName);
        if (paramValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(paramValue);
    }
}

