/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.auth;

import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.cnri.util.StringUtils;

public class HandleAuthorizationHeader {
    private static final String token = "[-A-Za-z0-9!#$%&'*+.`^_|~]++";
    private static final String quotedString = "\"[^\\\\\"]*+(?>\\\\.[^\\\\\"]*+)*+\"";
    private static final Pattern handleAuthorizationHeaderPattern = Pattern.compile("\\s*+Handle\\s++(.*+)", 34);
    private static final Pattern handleAuthorizationHeaderParamPattern = Pattern.compile("\\s*+([-A-Za-z0-9!#$%&'*+.`^_|~]++)\\s*+=\\s*+([-A-Za-z0-9!#$%&'*+.`^_|~]++|\"[^\\\\\"]*+(?>\\\\.[^\\\\\"]*+)*+\")\\s*+((?>,\\s*+)*+)", 34);
    private String version;
    private String clientCert;
    private String renegotiate;
    private String sessionId;
    private String id;
    private String cnonce;
    private String type;
    private String alg;
    private String signature;
    private String salt;
    private String iterations;
    private String length;

    public static HandleAuthorizationHeader fromHeader(String header) {
        if (header == null) {
            return null;
        }
        Matcher m = handleAuthorizationHeaderPattern.matcher(header);
        if (!m.matches()) {
            return null;
        }
        boolean comma = true;
        if (m.group(1).isEmpty()) {
            return null;
        }
        m = handleAuthorizationHeaderParamPattern.matcher(m.group(1));
        HandleAuthorizationHeader res = new HandleAuthorizationHeader();
        boolean done = false;
        while (!done && m.find()) {
            if (!comma) {
                return null;
            }
            String key = m.group(1);
            String value = HandleAuthorizationHeader.unquote(m.group(2));
            if (HandleAuthorizationHeader.isPercentEncoded(key)) {
                value = StringUtils.decodeURLIgnorePlus((String)value);
            }
            res.put(key, value);
            comma = m.group(3) != null && !m.group(3).isEmpty();
            done = m.end() == m.regionEnd();
        }
        if (!done) {
            return null;
        }
        return res;
    }

    private static boolean isPercentEncoded(String key) {
        return key.equalsIgnoreCase("id");
    }

    public static HandleAuthorizationHeader fromHeaderAndParameters(String header, HttpServletRequest req) {
        HandleAuthorizationHeader res = HandleAuthorizationHeader.fromHeader(header);
        if (res == null) {
            res = new HandleAuthorizationHeader();
        }
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = req.getParameter(name);
            if (value == "") {
                value = "true";
            }
            res.putIfAbsent(name, value);
        }
        return res;
    }

    static String unquote(String s) {
        if (!s.startsWith("\"") || !s.endsWith("\"")) {
            return s;
        }
        s = s.substring(1, s.length() - 1);
        s = s.replaceAll("\\\\(.)", "$1");
        return s;
    }

    public boolean isAuthenticating() {
        return this.id != null || this.type != null || this.alg != null || this.signature != null;
    }

    public Boolean getClientCertAsBooleanObject() {
        if (this.clientCert == null) {
            return null;
        }
        return Boolean.parseBoolean(this.clientCert);
    }

    public boolean isRequestingForceRenegotiate() {
        return Boolean.parseBoolean(this.renegotiate);
    }

    public boolean requiresSession() {
        return this.sessionId != null || this.isAuthenticating() || this.isRequestingServerSignature();
    }

    public boolean isIncompleteAuthentication() {
        return this.id == null || this.cnonce == null || this.type == null || this.alg == null || this.signature == null;
    }

    public boolean isRequestingServerSignature() {
        return this.cnonce != null && this.id == null;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getId() {
        return this.id;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getType() {
        return this.type;
    }

    public String getAlg() {
        return this.alg;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getIterations() {
        return this.iterations;
    }

    public String getLength() {
        return this.length;
    }

    public String getClientCert() {
        return this.clientCert;
    }

    public String getRenegotiate() {
        return this.renegotiate;
    }

    public void put(String s, String v) {
        if (s.equalsIgnoreCase("version")) {
            this.version = v;
        } else if (s.equalsIgnoreCase("sessionId")) {
            this.sessionId = v;
        } else if (s.equalsIgnoreCase("id")) {
            this.id = v;
        } else if (s.equalsIgnoreCase("cnonce")) {
            this.cnonce = v;
        } else if (s.equalsIgnoreCase("type")) {
            this.type = v;
        } else if (s.equalsIgnoreCase("alg")) {
            this.alg = v;
        } else if (s.equalsIgnoreCase("signature")) {
            this.signature = v;
        } else if (s.equalsIgnoreCase("salt")) {
            this.salt = v;
        } else if (s.equalsIgnoreCase("iterations")) {
            this.iterations = v;
        } else if (s.equalsIgnoreCase("length")) {
            this.length = v;
        } else if (s.equalsIgnoreCase("clientCert")) {
            this.clientCert = v;
        } else if (s.equalsIgnoreCase("renegotiate")) {
            this.renegotiate = v;
        }
    }

    public void putIfAbsent(String s, String v) {
        if (s.equalsIgnoreCase("version") && this.version == null) {
            this.version = v;
        } else if (s.equalsIgnoreCase("sessionId") && this.sessionId == null) {
            this.sessionId = v;
        } else if (s.equalsIgnoreCase("id") && this.id == null) {
            this.id = v;
        } else if (s.equalsIgnoreCase("cnonce") && this.cnonce == null) {
            this.cnonce = v;
        } else if (s.equalsIgnoreCase("type") && this.type == null) {
            this.type = v;
        } else if (s.equalsIgnoreCase("alg") && this.alg == null) {
            this.alg = v;
        } else if (s.equalsIgnoreCase("signature") && this.signature == null) {
            this.signature = v;
        } else if (s.equalsIgnoreCase("salt") && this.salt == null) {
            this.salt = v;
        } else if (s.equalsIgnoreCase("iterations") && this.iterations == null) {
            this.iterations = v;
        } else if (s.equalsIgnoreCase("length") && this.length == null) {
            this.length = v;
        } else if (s.equalsIgnoreCase("clientCert") && this.clientCert == null) {
            this.clientCert = v;
        } else if (s.equalsIgnoreCase("renegotiate") && this.renegotiate == null) {
            this.renegotiate = v;
        }
    }

    public String toString() {
        String res = "HandleAuthorizationHeader [version=" + this.version + ", clientCert=" + this.clientCert + ", renegotiate=" + this.renegotiate + ", sessionId=" + this.sessionId + ", id=" + this.id + ", cnonce=" + this.cnonce + ", type=" + this.type + ", alg=" + this.alg + ", signature=" + this.signature;
        if (this.salt != null) {
            res = res + ", salt=" + this.salt + ", iterations=" + this.iterations + ", length=" + this.length;
        }
        return res + "]";
    }
}

