/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.auth;

import java.security.PrivateKey;
import java.security.Signature;
import javax.servlet.http.HttpSession;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.auth.AuthenticationInfoWithId;
import net.handle.server.servletcontainer.auth.AuthenticationResponse;
import net.handle.server.servletcontainer.auth.HandleAuthorizationHeader;
import org.apache.commons.codec.binary.Base64;

public class HandleAuthenticationStatus {
    private final String sessionId;
    private final byte[] nonce;
    private final byte[] cnonce;
    private final byte[] serverSignature;
    private final String authorizationHeader;
    private final AuthenticationInfo authInfo;
    private final String id;

    public HandleAuthenticationStatus(String sessionId, byte[] nonce, byte[] cnonce, byte[] serverSignature, String authorizationHeader, AuthenticationInfo authInfo, String id) {
        this.sessionId = sessionId;
        this.nonce = nonce;
        this.cnonce = cnonce;
        this.serverSignature = serverSignature;
        this.authorizationHeader = authorizationHeader;
        this.authInfo = authInfo;
        this.id = id;
    }

    public static byte[] generateNonce() {
        return ChallengeResponse.generateNonce();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getCnonce() {
        return this.cnonce;
    }

    public byte[] getServerSignature() {
        return this.serverSignature;
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public AuthenticationInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getId() {
        return this.id;
    }

    public AuthenticationInfoWithId getAuthInfoWithId() {
        if (this.authInfo == null) {
            return null;
        }
        return new AuthenticationInfoWithId(this.id, this.authInfo);
    }

    public static String getServerAlg(HandleServerInterface handleServer) throws HandleException {
        return Util.decodeString(Util.getHashAlgIdFromSigId(Util.getDefaultSigId(handleServer.getPrivateKey().getAlgorithm())));
    }

    private byte[] buildServerSignature(HandleServerInterface handleServer, byte[] cnonceParam) throws HandleException {
        PrivateKey privateKey = handleServer.getPrivateKey();
        try {
            Signature signer = Signature.getInstance(Util.getDefaultSigId(privateKey.getAlgorithm()));
            signer.initSign(privateKey);
            signer.update(this.nonce);
            signer.update(cnonceParam);
            byte[] signatureBytes = signer.sign();
            return signatureBytes;
        }
        catch (Exception e) {
            throw new HandleException(1, "Unable to sign challenge", e);
        }
    }

    public static HandleAuthenticationStatus fromSession(HttpSession session, boolean create) {
        if (session == null) {
            return null;
        }
        HandleAuthenticationStatus res = (HandleAuthenticationStatus)session.getAttribute(HandleAuthenticationStatus.class.getName());
        if (res != null) {
            return res;
        }
        if (!create) {
            return null;
        }
        res = new HandleAuthenticationStatus(session.getId(), HandleAuthenticationStatus.generateNonce(), null, null, null, null, null);
        session.setAttribute(HandleAuthenticationStatus.class.getName(), (Object)res);
        return res;
    }

    public static HandleAuthenticationStatus processServerSignature(HandleAuthenticationStatus status, HandleServerInterface handleServer, HttpSession session, HandleAuthorizationHeader handleAuthHeader, AuthenticationResponse authResp) {
        if (handleAuthHeader != null && handleAuthHeader.isRequestingServerSignature() && handleServer != null) {
            authResp.setSessionId(status.getSessionId());
            authResp.setNonce(status.getNonce());
            try {
                byte[] serverSignature;
                byte[] cnonce = Base64.decodeBase64((String)handleAuthHeader.getCnonce());
                if (status.getServerSignature() != null && Util.equals(cnonce, status.getCnonce())) {
                    serverSignature = status.getServerSignature();
                } else {
                    serverSignature = status.buildServerSignature(handleServer, cnonce);
                    status = new HandleAuthenticationStatus(status.getSessionId(), status.getNonce(), cnonce, serverSignature, status.getAuthorizationHeader(), status.getAuthInfo(), status.getId());
                    session.setAttribute(HandleAuthenticationStatus.class.getName(), (Object)status);
                }
                authResp.setServerSignature(serverSignature);
                authResp.setServerAlg(HandleAuthenticationStatus.getServerAlg(handleServer));
            }
            catch (HandleException e) {
                authResp.getErrors().add(e.toString());
            }
        }
        return status;
    }
}

