/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.handle.server.SystemInfoWrapper;
import net.handle.util.FileSystemReadOnlyChecker;

public class MonitorDaemon
extends Thread {
    private volatile String monitorDataString;
    private final int sleepSeconds;
    private final long startTime;
    private final Gson gson = new Gson();
    private SystemInfoWrapper systemInfoWrapper;
    private final AtomicLong numRequests;
    private final AtomicLong numResolutionRequests;
    private final AtomicLong numAdminRequests;
    private final AtomicLong numTxnRequests;
    private final File baseDir;
    private AtomicInteger requestsPastMinute;
    private AtomicInteger peakRequestsPerMinute;
    private volatile boolean keepRunning = true;

    public MonitorDaemon(int sleepSeconds, long startTime, AtomicLong numRequests, AtomicLong numResolutionRequests, AtomicLong numAdminRequests, AtomicLong numTxnRequests, File baseDir) {
        super("MonitorDaemon");
        this.setDaemon(true);
        this.sleepSeconds = sleepSeconds;
        this.startTime = startTime;
        this.numRequests = numRequests;
        this.numResolutionRequests = numResolutionRequests;
        this.numAdminRequests = numAdminRequests;
        this.numTxnRequests = numTxnRequests;
        this.baseDir = baseDir;
        this.initializeSystemInfoWrapper();
    }

    public void setRequestCounters(AtomicInteger requestsPastMinute, AtomicInteger peakRequestsPerMinute) {
        this.requestsPastMinute = requestsPastMinute;
        this.peakRequestsPerMinute = peakRequestsPerMinute;
    }

    private void initializeSystemInfoWrapper() {
        try {
            if (System.getProperty("org.slf4j.simpleLogger.showDateTime") == null) {
                System.setProperty("org.slf4j.simpleLogger.showDateTime", "true");
            }
            if (System.getProperty("org.slf4j.simpleLogger.dateTimeFormat") == null) {
                System.setProperty("org.slf4j.simpleLogger.dateTimeFormat", "yyyy-MM-dd HH:mm:ss.SSSZ");
            }
            this.systemInfoWrapper = new SystemInfoWrapper();
        }
        catch (Throwable e) {
            System.err.println("Error initializing SystemInfoWrapper in MonitorDaemon: " + e);
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                JsonObject monitorData = this.getServerInfo();
                this.monitorDataString = this.gson.toJson((JsonElement)monitorData);
                for (int i = 0; i < this.sleepSeconds && this.keepRunning; ++i) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void shutdown() {
        this.keepRunning = false;
    }

    public String getStatusString() {
        return this.monitorDataString;
    }

    private JsonObject getServerInfo() {
        JsonObject systemInfo = new JsonObject();
        systemInfo.addProperty("version", "9.3.2");
        if (this.systemInfoWrapper != null) {
            try {
                systemInfo.add("loadAvg", (JsonElement)this.getLoadAverageInfo());
                systemInfo.addProperty("domainName", this.getFQDN());
                systemInfo.add("mem", (JsonElement)this.getMemInfo());
                systemInfo.add("diskInfo", (JsonElement)this.getDiskInfo());
            }
            catch (Exception e) {
                systemInfo.addProperty("systemInfoError", e.toString());
            }
        }
        if (this.baseDir != null) {
            systemInfo.addProperty("isReadOnly", Boolean.valueOf(this.testIfFileSystemIsReadOnly()));
        }
        systemInfo.addProperty("startTime", (Number)this.startTime);
        if (this.numRequests != null) {
            systemInfo.add("requests", (JsonElement)this.getReqInfo());
        }
        if (this.requestsPastMinute != null) {
            systemInfo.add("requestsPerMinute", (JsonElement)this.getProxyReqInfo());
        }
        systemInfo.addProperty("lastUpdate", (Number)System.currentTimeMillis());
        return systemInfo;
    }

    private JsonObject getReqInfo() {
        JsonObject reqTable = new JsonObject();
        reqTable.addProperty("resolution", (Number)this.numResolutionRequests);
        reqTable.addProperty("admin", (Number)this.numAdminRequests);
        reqTable.addProperty("txn", (Number)this.numTxnRequests);
        reqTable.addProperty("total", (Number)this.numRequests);
        return reqTable;
    }

    private JsonObject getProxyReqInfo() {
        JsonObject reqTable = new JsonObject();
        reqTable.addProperty("recent", (Number)this.requestsPastMinute.get());
        reqTable.addProperty("peak", (Number)this.peakRequestsPerMinute.get());
        return reqTable;
    }

    private boolean testIfFileSystemIsReadOnly() {
        return FileSystemReadOnlyChecker.isReadOnly(this.baseDir);
    }

    private String getFQDN() {
        return this.systemInfoWrapper.getFQDN();
    }

    private JsonArray getLoadAverageInfo() {
        return this.systemInfoWrapper.getLoadAverageInfo();
    }

    private JsonArray getDiskInfo() {
        return this.systemInfoWrapper.getDiskInfo();
    }

    private JsonObject getMemInfo() {
        return this.systemInfoWrapper.getMemInfo();
    }
}

