/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.Util;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureJsonSerialization;
import net.handle.hdllib.trust.TrustException;
import org.apache.commons.codec.binary.Base64;

public class JsonWebSignatureImpl
implements JsonWebSignature {
    private final String hashAlg;
    private final String keyAlg;
    private final byte[] header;
    private final byte[] serializedHeader;
    private final byte[] payload;
    private final byte[] serializedPayload;
    private final byte[] signature;
    private final byte[] serializedSignature;

    public JsonWebSignatureImpl(String payload, PrivateKey privateKey) throws TrustException {
        this(Util.encodeString(payload), privateKey);
    }

    public JsonWebSignatureImpl(byte[] payload, PrivateKey privateKey) throws TrustException {
        this.payload = payload;
        this.keyAlg = privateKey.getAlgorithm();
        if ("RSA".equals(this.keyAlg)) {
            this.hashAlg = "SHA256";
            this.header = Util.encodeString("{\"alg\":\"RS256\"}");
        } else if ("DSA".equals(this.keyAlg)) {
            this.hashAlg = "SHA256";
            this.header = Util.encodeString("{\"alg\":\"DS256\"}");
        } else {
            throw new IllegalArgumentException("Unsupported key algorithm " + this.keyAlg);
        }
        this.serializedHeader = Base64.encodeBase64URLSafe((byte[])this.header);
        this.serializedPayload = Base64.encodeBase64URLSafe((byte[])payload);
        try {
            Signature sig = Signature.getInstance(this.hashAlg + "with" + this.keyAlg);
            sig.initSign(privateKey);
            sig.update(this.serializedHeader);
            sig.update((byte)46);
            sig.update(this.serializedPayload);
            this.signature = sig.sign();
            this.serializedSignature = Base64.encodeBase64URLSafe((byte[])this.signature);
        }
        catch (Exception e) {
            throw new TrustException("Error creating JWS", (Throwable)e);
        }
    }

    public JsonWebSignatureImpl(String serialization) throws TrustException {
        if (JsonWebSignatureImpl.isCompact(serialization)) {
            try {
                String[] dotSeparatedParts = serialization.split("\\.");
                this.serializedHeader = Util.encodeString(dotSeparatedParts[0]);
                this.header = Base64.decodeBase64((byte[])this.serializedHeader);
                this.serializedPayload = Util.encodeString(dotSeparatedParts[1]);
                this.payload = Base64.decodeBase64((byte[])this.serializedPayload);
                this.serializedSignature = Util.encodeString(dotSeparatedParts[2]);
                this.signature = Base64.decodeBase64((byte[])this.serializedSignature);
            }
            catch (Exception e) {
                throw new TrustException("Couldn't parse JWS", (Throwable)e);
            }
        } else {
            Gson gson = GsonUtility.getGson();
            JsonWebSignatureJsonSerialization jwsjs = (JsonWebSignatureJsonSerialization)gson.fromJson(serialization, JsonWebSignatureJsonSerialization.class);
            this.serializedHeader = Util.encodeString(jwsjs.signatures.get((int)0).protectedPart);
            this.header = Base64.decodeBase64((byte[])this.serializedHeader);
            this.serializedPayload = Util.encodeString(jwsjs.payload);
            this.payload = Base64.decodeBase64((byte[])this.serializedPayload);
            this.serializedSignature = Util.encodeString(jwsjs.signatures.get((int)0).signature);
            this.signature = Base64.decodeBase64((byte[])this.serializedSignature);
        }
        String algString = JsonWebSignatureImpl.getAlgStringFromHeader(this.header);
        this.keyAlg = JsonWebSignatureImpl.getKeyAlgFromAlg(algString);
        this.hashAlg = JsonWebSignatureImpl.getHashAlgFromAlg(algString);
    }

    private static String getAlgStringFromHeader(byte[] header) throws TrustException {
        try {
            String alg = JsonParser.parseString((String)Util.decodeString(header)).getAsJsonObject().get("alg").getAsString();
            return alg;
        }
        catch (Exception e) {
            throw new TrustException("Couldn't parse JWS header", (Throwable)e);
        }
    }

    private static String getKeyAlgFromAlg(String alg) throws TrustException {
        if (alg.startsWith("RS")) {
            return "RSA";
        }
        if (alg.startsWith("DS")) {
            return "DSA";
        }
        throw new TrustException("Couldn't parse JWS header");
    }

    private static String getHashAlgFromAlg(String alg) throws TrustException {
        if (alg.endsWith("256")) {
            return "SHA256";
        }
        if (alg.endsWith("160") || alg.endsWith("128") || alg.equals("DSA") || alg.equals("DS")) {
            return "SHA1";
        }
        if (alg.endsWith("384")) {
            return "SHA384";
        }
        if (alg.endsWith("512")) {
            return "SHA512";
        }
        throw new TrustException("Couldn't parse JWS header");
    }

    private static boolean isCompact(String serialization) {
        return !serialization.trim().startsWith("{");
    }

    @Override
    public String getPayloadAsString() {
        return Util.decodeString(this.payload);
    }

    @Override
    public byte[] getPayloadAsBytes() {
        return (byte[])this.payload.clone();
    }

    @Override
    public boolean validates(PublicKey publicKey) throws TrustException {
        if (!this.keyAlg.equals(publicKey.getAlgorithm())) {
            return false;
        }
        try {
            Signature sig = Signature.getInstance(this.hashAlg + "with" + publicKey.getAlgorithm());
            sig.initVerify(publicKey);
            sig.update(this.serializedHeader);
            sig.update((byte)46);
            sig.update(this.serializedPayload);
            return sig.verify(this.signature);
        }
        catch (Exception e) {
            throw new TrustException("Error validating JWS", (Throwable)e);
        }
    }

    @Override
    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.decodeString(this.serializedHeader));
        sb.append('.');
        sb.append(Util.decodeString(this.serializedPayload));
        sb.append('.');
        sb.append(Util.decodeString(this.serializedSignature));
        return sb.toString();
    }

    @Override
    public String serializeToJson() {
        String headerEncoded = Util.decodeString(this.serializedHeader);
        String payloadEncoded = Util.decodeString(this.serializedPayload);
        String signatureEncoded = Util.decodeString(this.serializedSignature);
        String json = "{\"payload\":\"" + payloadEncoded + "\",\"signatures\":[{\"protected\":\"" + headerEncoded + "\",\"signature\":\"" + signatureEncoded + "\"}]}";
        return json;
    }
}

