/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.trust.DigestedHandleValues;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleValueDigester;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.IssuedSignatureVerificationReport;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.Permission;
import net.handle.hdllib.trust.SignatureVerificationReport;
import net.handle.hdllib.trust.ValuesSignatureVerificationReport;

public class HandleVerifier {
    private static HandleVerifier INSTANCE = new HandleVerifier();

    public static HandleVerifier getInstance() {
        return INSTANCE;
    }

    public ValuesSignatureVerificationReport verifyValues(String handle, List<HandleValue> values, JsonWebSignature signature, PublicKey publicKey) {
        DigestedHandleValues digestedHandleValues;
        ValuesSignatureVerificationReport report = new ValuesSignatureVerificationReport();
        this.verifyHandleClaimsSetAndSetReportProperties(report, signature, publicKey);
        HandleClaimsSet claims = this.getHandleClaimsSet(signature);
        if (claims == null) {
            return report;
        }
        report.correctHandle = Util.equalsPrefixCI(handle, claims.sub);
        if (claims.digests == null || claims.digests.alg == null) {
            report.validPayload = false;
            return report;
        }
        try {
            digestedHandleValues = new HandleValueDigester().digest(values, claims.digests.alg);
        }
        catch (NoSuchAlgorithmException e) {
            report.validPayload = false;
            report.exceptions.add(e.toString());
            return report;
        }
        report.verifiedValues = this.getVerifiedValues(digestedHandleValues.digests, claims.digests.digests);
        report.unsignedValues = this.getUnsignedValues(digestedHandleValues.digests, claims.digests.digests);
        report.badDigestValues = this.getBadDigestValues(digestedHandleValues.digests, claims.digests.digests);
        report.missingValues = this.getMissingValues(digestedHandleValues.digests, claims.digests.digests);
        report.iss = claims.iss;
        report.sub = claims.sub;
        return report;
    }

    public HandleClaimsSet getHandleClaimsSet(JsonWebSignature signature) {
        HandleClaimsSet claims = null;
        try {
            String payload = signature.getPayloadAsString();
            claims = (HandleClaimsSet)GsonUtility.getGson().fromJson(payload, HandleClaimsSet.class);
        }
        catch (Exception e) {
            return null;
        }
        return claims;
    }

    public void verifyHandleClaimsSetAndSetReportProperties(SignatureVerificationReport report, JsonWebSignature signature, PublicKey publicKey) {
        HandleClaimsSet claims;
        try {
            report.signatureVerifies = signature.validates(publicKey);
        }
        catch (Exception e) {
            report.signatureVerifies = false;
            report.exceptions.add(e.toString());
        }
        try {
            String payload = signature.getPayloadAsString();
            claims = (HandleClaimsSet)GsonUtility.getGson().fromJson(payload, HandleClaimsSet.class);
            report.validPayload = true;
        }
        catch (Exception e) {
            report.validPayload = false;
            report.exceptions.add(e.toString());
            return;
        }
        long nowInSeconds = System.currentTimeMillis() / 1000L;
        report.dateInRange = claims.isDateInRange(nowInSeconds);
    }

    List<Integer> getBadDigestValues(List<DigestedHandleValues.DigestedHandleValue> actual, List<DigestedHandleValues.DigestedHandleValue> claimedDigests) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (claimedDigests == null) {
            return result;
        }
        block0: for (DigestedHandleValues.DigestedHandleValue actualDigest : actual) {
            for (DigestedHandleValues.DigestedHandleValue claimedDigest : claimedDigests) {
                if (actualDigest.index != claimedDigest.index || actualDigest.digest.equals(claimedDigest.digest)) continue;
                result.add(actualDigest.index);
                continue block0;
            }
        }
        return result;
    }

    List<Integer> getVerifiedValues(List<DigestedHandleValues.DigestedHandleValue> actual, List<DigestedHandleValues.DigestedHandleValue> claimedDigests) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (claimedDigests == null) {
            return result;
        }
        block0: for (DigestedHandleValues.DigestedHandleValue actualDigest : actual) {
            for (DigestedHandleValues.DigestedHandleValue claimedDigest : claimedDigests) {
                if (actualDigest.index != claimedDigest.index || !actualDigest.digest.equals(claimedDigest.digest)) continue;
                result.add(actualDigest.index);
                continue block0;
            }
        }
        return result;
    }

    List<Integer> getUnsignedValues(List<DigestedHandleValues.DigestedHandleValue> actual, List<DigestedHandleValues.DigestedHandleValue> claimedDigests) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (claimedDigests == null) {
            for (DigestedHandleValues.DigestedHandleValue actualDigest : actual) {
                result.add(actualDigest.index);
            }
            return result;
        }
        for (DigestedHandleValues.DigestedHandleValue actualDigest : actual) {
            boolean found = false;
            for (DigestedHandleValues.DigestedHandleValue claimedDigest : claimedDigests) {
                if (actualDigest.index != claimedDigest.index) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(actualDigest.index);
        }
        return result;
    }

    List<Integer> getMissingValues(List<DigestedHandleValues.DigestedHandleValue> actual, List<DigestedHandleValues.DigestedHandleValue> claimedDigests) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (claimedDigests == null) {
            return result;
        }
        for (DigestedHandleValues.DigestedHandleValue claimedDigest : claimedDigests) {
            boolean found = false;
            for (DigestedHandleValues.DigestedHandleValue actualDigest : actual) {
                if (actualDigest.index != claimedDigest.index) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(claimedDigest.index);
        }
        return result;
    }

    public void verifyIssuedSignatureIsValid(IssuedSignature issuedSignature, SignatureVerificationReport report) {
        this.verifyHandleClaimsSetAndSetReportProperties(report, issuedSignature.jws, issuedSignature.issuerPublicKey);
    }

    public boolean verifyPermissionsAreAuthorizedOverHandle(String handle, List<Permission> perms) {
        if (perms == null || perms.isEmpty()) {
            return false;
        }
        for (Permission permission : perms) {
            if ("everything".equals(permission.perm)) {
                return true;
            }
            if (!("thisHandle".equals(permission.perm) ? Util.equalsPrefixCI(handle, permission.handle) || Util.isHandleUnderPrefix(handle, permission.handle) : ("derivedPrefixes".equals(permission.perm) ? Util.isDerivedFrom(handle, permission.handle) || Util.isDerivedFrom(Util.getZeroNAHandle(handle), permission.handle) : "handlesUnderThisPrefix".equals(permission.perm) && Util.isHandleUnderPrefix(handle, permission.handle)))) continue;
            return true;
        }
        return false;
    }

    public void verifyIssuedSignatureIsAuthorizedOverHandle(String handle, IssuedSignature issuedSignature, IssuedSignatureVerificationReport report) {
        boolean verified = this.verifyPermissionsAreAuthorizedOverHandle(handle, issuedSignature.issuerPermissions);
        report.authorized = verified;
    }

    public IssuedSignatureVerificationReport verifyIssuedSignature(String handle, IssuedSignature issuedSignature) {
        IssuedSignatureVerificationReport report = new IssuedSignatureVerificationReport();
        HandleClaimsSet claims = this.getHandleClaimsSet(issuedSignature.jws);
        report.iss = claims.iss;
        report.sub = claims.sub;
        this.verifyIssuedSignatureIsValid(issuedSignature, report);
        if (handle != null) {
            this.verifyIssuedSignatureIsAuthorizedOverHandle(handle, issuedSignature, report);
        }
        return report;
    }
}

