/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import net.handle.hdllib.trust.AbstractRequiredSignerStore;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;

public class FileBasedRequiredSignerStore
extends AbstractRequiredSignerStore {
    protected File requiredSignersDir;
    private volatile long lastModified;

    public FileBasedRequiredSignerStore(File requiredSignersDir) {
        this.requiredSignersDir = requiredSignersDir;
    }

    @Override
    public synchronized void loadSigners() {
        ArrayList<JsonWebSignature> certs = new ArrayList<JsonWebSignature>();
        long newLastModified = this.requiredSignersDir.lastModified();
        File[] files = this.requiredSignersDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) continue;
                long thisFileLastModified = f.lastModified();
                if (thisFileLastModified > newLastModified) {
                    newLastModified = thisFileLastModified;
                }
                try {
                    String serialization = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
                    JsonWebSignature cert = JsonWebSignatureFactory.getInstance().deserialize(serialization);
                    if (!this.validateSelfSignedCert(cert)) {
                        System.err.println("Required signer cert did not validate. " + f.getName());
                        continue;
                    }
                    certs.add(cert);
                }
                catch (TrustException e) {
                    System.err.println("Required signer cert could not be loaded. " + f.getName());
                    e.printStackTrace();
                }
                catch (IOException e) {
                    System.err.println("Required signer cert could not be loaded. " + f.getName());
                    e.printStackTrace();
                }
            }
        }
        this.lastModified = newLastModified;
        this.requiredSigners = certs;
    }

    @Override
    public boolean needsLoadSigners() {
        if (this.requiredSignersDir.lastModified() > this.lastModified) {
            return true;
        }
        File[] files = this.requiredSignersDir.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (f.isDirectory() || f.lastModified() <= this.lastModified) continue;
            return true;
        }
        return false;
    }
}

