/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.util.List;
import net.handle.hdllib.trust.IssuedSignatureVerificationReport;
import net.handle.hdllib.trust.ValuesSignatureVerificationReport;

public class ChainVerificationReport {
    public ValuesSignatureVerificationReport valuesReport;
    public List<IssuedSignatureVerificationReport> issuedSignatureVerificationReports;
    public boolean rootIsTrusted;
    public boolean chainNeedsRequiredSigner;
    public boolean chainGoodUpToRequiredSigner;
    public boolean unableToBuildChain;

    public boolean canTrustAndAuthorized() {
        if (!this.rootIsTrusted) {
            return false;
        }
        if (!this.valuesReport.correctHandle) {
            return false;
        }
        if (!this.valuesReport.canTrust()) {
            return false;
        }
        for (IssuedSignatureVerificationReport issuedSignatureVerificationReport : this.issuedSignatureVerificationReports) {
            if (issuedSignatureVerificationReport.canTrustAndAuthorized()) continue;
            return false;
        }
        return true;
    }

    public boolean canTrustAndAuthorizedUpToRequiredSigner() {
        if (!this.chainNeedsRequiredSigner) {
            return false;
        }
        if (!this.rootIsTrusted) {
            return false;
        }
        if (this.isRequiredSignerNeededAndChainIsGoodUpToRequiredSigner()) {
            return false;
        }
        if (!this.valuesReport.correctHandle) {
            return false;
        }
        return this.valuesReport.canTrust();
    }

    public boolean isRequiredSignerNeededAndChainIsGoodUpToRequiredSigner() {
        return this.chainNeedsRequiredSigner && !this.chainGoodUpToRequiredSigner;
    }

    public boolean canTrust() {
        if (!this.rootIsTrusted) {
            return false;
        }
        for (IssuedSignatureVerificationReport issuedSignatureVerificationReport : this.issuedSignatureVerificationReports) {
            if (issuedSignatureVerificationReport.canTrust()) continue;
            return false;
        }
        return true;
    }
}

