/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Date;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class Transaction {
    public static final byte ACTION_PLACEHOLDER = 0;
    public static final byte ACTION_CREATE_HANDLE = 1;
    public static final byte ACTION_DELETE_HANDLE = 2;
    public static final byte ACTION_UPDATE_HANDLE = 3;
    public static final byte ACTION_HOME_NA = 4;
    public static final byte ACTION_UNHOME_NA = 5;
    public static final byte ACTION_DELETE_ALL = 6;
    public long txnId;
    public byte[] handle;
    public byte action;
    public long date;
    public int hashOnAll;
    public int hashOnNA;
    public int hashOnId;
    public HandleValue[] values = null;

    public String toString() {
        return "Transaction[txn: id=" + this.txnId + "; action=" + Transaction.actionToString(this.action) + "; hdl=" + Util.decodeString(this.handle) + "; date=" + new Date(this.date) + ";]";
    }

    public static final String actionToString(byte action) {
        switch (action) {
            case 0: {
                return "placeholder";
            }
            case 1: {
                return "create";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "update";
            }
            case 4: {
                return "home";
            }
            case 5: {
                return "unhome";
            }
            case 6: {
                return "delete_all!";
            }
        }
        return "unknown";
    }

    public static final byte stringToAction(String action) {
        if ("placeholder".equals(action)) {
            return 0;
        }
        if ("create".equals(action)) {
            return 1;
        }
        if ("delete".equals(action)) {
            return 2;
        }
        if ("update".equals(action)) {
            return 3;
        }
        if ("home".equals(action)) {
            return 4;
        }
        if ("unhome".equals(action)) {
            return 5;
        }
        if ("delete_all!".equals(action)) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    public Transaction() {
    }

    public Transaction(long txnId, byte[] handle, HandleValue[] values, byte action, long date) {
        this(txnId, handle, action, date);
        this.values = values;
    }

    public Transaction(long txnId, byte[] handle, byte action, long date) {
        this.txnId = txnId;
        this.handle = handle;
        this.action = action;
        this.date = date;
        try {
            this.hashOnAll = SiteInfo.getHandleHash(handle, 2);
            this.hashOnNA = SiteInfo.getHandleHash(handle, 0);
            this.hashOnId = SiteInfo.getHandleHash(handle, 1);
        }
        catch (HandleException e) {
            throw new AssertionError((Object)e);
        }
    }
}

