/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class Tester {
    private final HandleResolver resolver;
    private static int testerCount = 0;
    static int numberOfTestThreads = 0;
    private long startTime;
    private long endTime;
    private int successes = 0;
    private int failures = 0;
    private static HandleValue[] valuesToCreate = new HandleValue[]{new HandleValue(1, Common.STD_TYPE_URL, Util.encodeString("http://handle.net/")), new HandleValue(2, Common.STD_TYPE_EMAIL, Util.encodeString("hdladmin@cnri.reston.va.us")), new HandleValue(3, Common.STD_TYPE_HSADMIN, Encoder.encodeAdminRecord(new AdminRecord(Util.encodeString("200/0"), 300, true, true, true, true, true, true, true, true, true, true, true, true)))};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        SiteInfo[] sites;
        if (argv.length < 1) {
            System.err.println("Usage:  java net.handle.hdllib.Tester <handle> <#queries/thread> <#threads> <site_info_file>");
            return;
        }
        String handle = argv[0];
        int queries = argv.length > 1 ? Integer.parseInt(argv[1]) : 1000;
        int threads = argv.length > 2 ? Integer.parseInt(argv[2]) : 20;
        File siteInfoFile = argv.length > 3 ? new File(argv[3]) : null;
        HandleResolver resolver = new HandleResolver();
        Tester tester = new Tester(resolver);
        System.err.println("Site info file: " + siteInfoFile);
        if (siteInfoFile != null) {
            byte[] buf = new byte[(int)siteInfoFile.length()];
            int r = 0;
            try (FileInputStream fin = new FileInputStream(siteInfoFile);){
                for (int n = 0; n < buf.length && (r = fin.read(buf, n, buf.length - n)) >= 0; n += r) {
                }
            }
            SiteInfo site = new SiteInfo();
            if (Util.looksLikeBinary(buf)) {
                Encoder.decodeSiteInfoRecord(buf, 0, site);
            } else {
                site = SiteInfoConverter.convertToSiteInfo(new String(buf, "UTF-8"));
            }
            sites = new SiteInfo[]{site};
            resolver.setCache(null);
            resolver.setCertifiedCache(null);
        } else {
            sites = resolver.findLocalSites(new ResolutionRequest(Util.encodeString(handle), null, null, null));
        }
        resolver.getConfiguration().setCacheSites(sites);
        resolver.getConfiguration().setResolutionMethod(1);
        numberOfTestThreads = threads;
        tester.doTests(handle, queries, threads, sites);
    }

    public Tester(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public void doTests(String handle, int queries, int threads, SiteInfo[] sites) throws Exception {
        int i;
        ResolutionRequest req = new ResolutionRequest(Util.encodeString(handle), null, null, null);
        req.ignoreRestrictedValues = true;
        AbstractResponse response = this.resolver.processRequest(req);
        if (!(response instanceof ResolutionResponse)) {
            System.err.println(" aborting tests");
            return;
        }
        System.err.println(" number of values: " + ((ResolutionResponse)response).values.length);
        Vector<SubTester> testers = new Vector<SubTester>();
        Vector<Thread> threadV = new Vector<Thread>();
        System.err.println("\nQuerying " + handle + " with " + threads + " threads, each performing " + queries + " queries");
        this.resolver.traceMessages = false;
        for (i = 0; i < threads; ++i) {
            SubTester t = new SubTester(this.resolver, handle, queries, i, threads, sites);
            testers.addElement(t);
            Thread th = new Thread(t);
            threadV.addElement(th);
            ++testerCount;
        }
        this.startTime = System.currentTimeMillis();
        for (i = 0; i < threads; ++i) {
            ((Thread)threadV.elementAt(i)).start();
        }
    }

    class SubTester
    implements Runnable {
        private final ResolutionRequest req;
        private final HandleResolver resolver;
        private final SiteInfo[] sites;
        private final int threadNum;
        private final int queries;
        private final int numThreads;

        public SubTester(HandleResolver resolver, String handle, int queries, int threadNum, int numThreads, SiteInfo[] sites) throws Exception {
            this.resolver = resolver;
            this.queries = queries;
            this.threadNum = threadNum;
            this.numThreads = numThreads;
            this.req = new ResolutionRequest(Util.encodeString(handle), null, null, null);
            this.sites = sites;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.queries; ++i) {
                try {
                    AbstractResponse resp = this.resolver.sendRequestToService(this.req, this.sites);
                    if (resp.getClass() == ResolutionResponse.class) {
                        Tester.this.successes++;
                        continue;
                    }
                    System.err.println("Error: " + this.threadNum + ':' + i + ": got unexpected response: " + resp);
                    Tester.this.failures++;
                    continue;
                }
                catch (Exception e) {
                    Tester.this.failures++;
                    System.err.println("Error: " + this.threadNum + ':' + i + ": " + e);
                }
            }
            boolean showResults = testerCount == numberOfTestThreads;
            testerCount--;
            if (showResults) {
                Tester.this.endTime = System.currentTimeMillis();
                long time = Tester.this.endTime - Tester.this.startTime;
                System.err.println("  milliseconds: " + time + "\n  seconds: " + time / 1000L + "\n  req/second: " + (double)(this.numThreads * this.queries) / (double)time * 1000.0 + "\n  successes: " + Tester.this.successes + "\n  failures: " + Tester.this.failures);
            }
        }
    }

    class CreateTester
    implements Runnable {
        private final CreateHandleRequest req;
        private final HandleResolver resolver;
        private final SiteInfo[] sites;
        private final int threadNum;
        private final int queries;
        private final int numThreads;

        public CreateTester(HandleResolver resolver, AuthenticationInfo auth, String handle, int queries, int threadNum, int numThreads) throws Exception {
            this.resolver = resolver;
            this.queries = queries;
            this.threadNum = threadNum;
            this.numThreads = numThreads;
            this.req = new CreateHandleRequest(Util.encodeString(handle), valuesToCreate, auth);
            this.sites = resolver.findLocalSites(this.req);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.queries; ++i) {
                try {
                    AbstractResponse resp = this.resolver.sendRequestToService(this.req, this.sites);
                    if (resp.getClass() == ResolutionResponse.class) {
                        Tester.this.successes++;
                        continue;
                    }
                    System.err.println("Error: " + this.threadNum + ':' + i + ": got unexpected response: " + resp);
                    Tester.this.failures++;
                    continue;
                }
                catch (Exception e) {
                    Tester.this.failures++;
                    System.err.println("Error: " + this.threadNum + ':' + i + ": " + e);
                }
            }
            testerCount--;
            if (testerCount == 0) {
                Tester.this.endTime = System.currentTimeMillis();
                long time = Tester.this.endTime - Tester.this.startTime;
                System.err.println("  milliseconds: " + time + "\n  seconds: " + time / 1000L + "\n  req/second: " + (double)(this.numThreads * this.queries) / (double)time * 1000.0 + "\n  successes: " + Tester.this.successes + "\n  failures: " + Tester.this.failures);
            }
        }
    }
}

