/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

class TemplateBuilder {
    public static final String TEMPLATE_TAG = "template";
    public static final String TEMPLATE_DELIMITER_ATT = "delimiter";
    public static final String REF_ATT = "ref";
    public static final int RECURSION_LIMIT = 10;
    private static XParser xmlParser = new XParser();
    HandleValue[] origvals;
    String handle;
    String base;
    String extension;
    boolean caseSensitive;
    HandleResolver resolver;
    short recursionCount;
    private NamespaceInfo parentNamespace;
    private XTag xmlInfo = null;
    private static final int NO_TEMPLATE = 0;
    private static final int NOT_FOUND = 1;
    private static final int HAS_TEMPLATE = 2;
    private static final Comparator<HandleValue> handleValueIndexComparator = (o1, o2) -> Integer.compare(o1.index, o2.index);

    public TemplateBuilder(HandleValue[] origvals, String handle, String base, String extension, boolean caseSensitive, HandleResolver resolver, short recursionCount) {
        this.origvals = origvals;
        this.handle = handle;
        this.base = base;
        this.extension = extension;
        this.caseSensitive = caseSensitive;
        this.resolver = resolver;
        this.recursionCount = recursionCount;
    }

    public void setXml(XTag tag) {
        this.xmlInfo = tag;
    }

    public void setParentNamespace(NamespaceInfo parentNamespace) {
        this.parentNamespace = parentNamespace;
    }

    private boolean templateConstructViaSubtags(HandleValue origval, List<HandleValue> resvals, XTag tag, TemplateReplacementMap map) {
        String valueKind = "extension";
        String parameter = "extension";
        String test = null;
        boolean negate = false;
        String expression = null;
        int count = tag.getSubTagCount();
        for (int i = 0; i < count; ++i) {
            String param;
            XTag subtag = tag.getSubTag(i);
            if (subtag.getName().equals("value")) {
                HandleValue resval;
                int index = subtag.getIntAttribute("index", -1);
                String type = subtag.getAttribute("type", null);
                String data = subtag.getAttribute("data", null);
                if (data == null) {
                    String xmlValueStr;
                    String string = xmlValueStr = subtag.getValue() == null ? null : String.valueOf(subtag.getValue());
                    if (xmlValueStr != null && xmlValueStr.length() > 0) {
                        data = xmlValueStr;
                    } else if (subtag.getSubTagCount() > 0) {
                        try {
                            StringWriter out = new StringWriter();
                            for (int j = 0; j < subtag.getSubTagCount(); ++j) {
                                subtag.getSubTag(j).write(out);
                            }
                            data = ((Object)out).toString();
                        }
                        catch (IOException out) {
                            // empty catch block
                        }
                    }
                }
                if (origval == null && (type == null || data == null)) continue;
                Collections.sort(resvals, handleValueIndexComparator);
                if (origval != null) {
                    resval = origval.duplicate();
                    if (index < 0) {
                        index = resval.index;
                    }
                } else {
                    resval = new HandleValue();
                    index = 1;
                }
                for (int j = 0; j < resvals.size(); ++j) {
                    if (index != resvals.get((int)j).index) continue;
                    ++index;
                }
                try {
                    resval.setIndex(index);
                    if (type != null) {
                        resval.setType(map.performReplace(type).getBytes("UTF-8"));
                    }
                    if (data != null) {
                        resval.setData(map.performReplace(data).getBytes("UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException j) {
                    // empty catch block
                }
                resvals.add(resval);
                continue;
            }
            if (subtag.getName().equals("if") || subtag.getName().equals("else")) {
                TemplateReplacementMap newMap;
                boolean notfound;
                Pattern cre;
                Matcher m;
                boolean notfound2;
                if (subtag.getName().equals("if")) {
                    valueKind = subtag.getAttribute("value", "extension");
                    parameter = subtag.getAttribute("parameter", valueKind);
                    test = subtag.getAttribute("test");
                    negate = subtag.getAttribute("negate", "").equals("true");
                    expression = subtag.getAttribute("expression");
                } else {
                    boolean bl = negate = !negate;
                }
                if (test == null && expression == null && !negate) {
                    boolean notfound3 = this.templateConstructViaSubtags(origval, resvals, subtag, map);
                    if (!notfound3) continue;
                    return true;
                }
                if (expression == null) continue;
                String value = map.get(valueKind);
                if (!(test == null || test.equals("equals") ? negate != value.equals(expression) && (notfound2 = this.templateConstructViaSubtags(origval, resvals, subtag, map.put(parameter, value))) : test.equals("matches") && negate != (m = (cre = Pattern.compile(expression, this.caseSensitive ? 0 : 66)).matcher(value)).matches() && (notfound = this.templateConstructViaSubtags(origval, resvals, subtag, newMap = negate ? map.put(parameter, value) : map.put(parameter, m))))) continue;
                return true;
            }
            if (subtag.getName().equals("notfound")) {
                return true;
            }
            if (subtag.getName().equals("foreach")) {
                if (origval != null) continue;
                for (HandleValue val : this.origvals) {
                    boolean notfound = this.templateConstructViaSubtags(val, resvals, subtag, map.put(val));
                    if (!notfound) continue;
                    return true;
                }
                continue;
            }
            if (!subtag.getName().equals("def") || (param = subtag.getAttribute("parameter")) == null) continue;
            ArrayList<HandleValue> defvals = new ArrayList<HandleValue>();
            boolean notfound = this.templateConstructViaSubtags(origval, defvals, subtag, map);
            if (notfound) {
                return true;
            }
            if (defvals.size() <= 0) continue;
            map = map.put(param, ((HandleValue)defvals.get(0)).getDataAsString());
        }
        return false;
    }

    public HandleValue[] templateConstruct() {
        TemplateReplacementMap map = new TemplateReplacementMap(this.handle, this.base, this.extension);
        ArrayList<HandleValue> resvals = new ArrayList<HandleValue>();
        int res = 0;
        while (res == 0) {
            res = this.templateConstruct(this.xmlInfo, resvals, map);
            if (res != 0) continue;
            if (this.parentNamespace == null) {
                return null;
            }
            this.parentNamespace.setupTemplateBuilderForNamespace(this);
        }
        if (res == 1) {
            return null;
        }
        return resvals.toArray(new HandleValue[0]);
    }

    private int templateConstruct(XTag tag, List<HandleValue> resvals, TemplateReplacementMap map) {
        if (tag == null) {
            return 0;
        }
        if (tag.getName().equals(TEMPLATE_TAG)) {
            String ref = tag.getAttribute(REF_ATT);
            if (ref != null) {
                int index;
                if (this.recursionCount >= 10) {
                    return 1;
                }
                int colon = ref.indexOf(58);
                if (colon < 0) {
                    return 0;
                }
                try {
                    index = Integer.parseInt(ref.substring(0, colon));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                String handle = ref.substring(colon + 1, ref.length());
                try {
                    ResolutionRequest req = new ResolutionRequest(Util.encodeString(handle), null, new int[]{index}, null);
                    req.recursionCount = this.recursionCount = (short)(this.recursionCount + 1);
                    AbstractResponse response = this.resolver.processRequest(req);
                    if (response.responseCode == 100 || response instanceof ErrorResponse) {
                        return 1;
                    }
                    HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
                    if (values == null || values.length == 0) {
                        return 1;
                    }
                    for (HandleValue value : values) {
                        if (value.index != index) continue;
                        try {
                            XTag citedTag = xmlParser.parse(new InputStreamReader((InputStream)new ByteArrayInputStream(value.data), "UTF-8"), false);
                            return this.templateConstruct(citedTag, resvals, map);
                        }
                        catch (Exception e) {
                            return 0;
                        }
                    }
                    return 1;
                }
                catch (HandleException e) {
                    e.printStackTrace();
                    return 1;
                }
            }
            boolean notfound = this.templateConstructViaSubtags(null, resvals, tag, map);
            if (notfound) {
                return 1;
            }
            return 2;
        }
        int count = tag.getSubTagCount();
        boolean hasTemplate = false;
        for (int i = 0; i < count; ++i) {
            XTag templateTag = tag.getSubTag(i);
            int res = 0;
            if (templateTag.getName().equals(TEMPLATE_TAG)) {
                res = this.templateConstruct(templateTag, resvals, map);
            }
            if (res == 1) {
                return 1;
            }
            if (res != 2) continue;
            hasTemplate = true;
        }
        if (hasTemplate) {
            return 2;
        }
        return 0;
    }

    private class TemplateReplacementMap {
        private final Map<String, String> stringMap;
        private final Map<String, Matcher> matcherMap;
        private String defaultKey = "extension";

        TemplateReplacementMap(TemplateReplacementMap map) {
            this.stringMap = new HashMap<String, String>(map.stringMap);
            this.matcherMap = new HashMap<String, Matcher>(map.matcherMap);
            this.defaultKey = map.defaultKey;
        }

        TemplateReplacementMap(String handle, String base, String extension) {
            this.stringMap = new HashMap<String, String>();
            this.matcherMap = new HashMap<String, Matcher>();
            this.stringMap.put("handle", handle);
            this.stringMap.put("base", base);
            this.stringMap.put("extension", extension);
        }

        TemplateReplacementMap put(String key, String val) {
            TemplateReplacementMap res = new TemplateReplacementMap(this);
            res.stringMap.put(key, val);
            res.matcherMap.remove(key);
            return res;
        }

        TemplateReplacementMap put(String key, Matcher val) {
            TemplateReplacementMap res = new TemplateReplacementMap(this);
            res.stringMap.put(key, val.group());
            res.matcherMap.put(key, val);
            return res;
        }

        TemplateReplacementMap put(HandleValue val) {
            TemplateReplacementMap res = new TemplateReplacementMap(this);
            res.stringMap.put("type", val.getTypeAsString());
            res.stringMap.put("data", val.getDataAsString());
            res.stringMap.put("index", String.valueOf(val.getIndex()));
            return res;
        }

        String get(String key, int group) {
            Matcher matcher = this.matcherMap.get(key);
            if (matcher != null) {
                if (group >= 0 && group <= matcher.groupCount()) {
                    return this.nz(matcher.group(group));
                }
                return "";
            }
            String res = this.stringMap.get(key);
            if (res != null) {
                if (group == 0) {
                    return res;
                }
                return "";
            }
            return "";
        }

        private String nz(String a) {
            if (a == null) {
                return "";
            }
            return a;
        }

        String get(String key) {
            int bracket;
            if (key.equals("")) {
                return this.nz(this.stringMap.get(key));
            }
            char ch = key.charAt(0);
            if (ch >= '0' && ch <= '9') {
                try {
                    int group = Integer.parseInt(key);
                    return this.nz(this.get(this.defaultKey, group));
                }
                catch (NumberFormatException group) {
                    // empty catch block
                }
            }
            if (key.charAt(key.length() - 1) == ']' && (bracket = key.lastIndexOf(91)) >= 0) {
                try {
                    int group = Integer.parseInt(key.substring(bracket + 1, key.length() - 1));
                    key = key.substring(0, bracket);
                    return this.nz(this.get(key, group));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.nz(this.stringMap.get(key));
        }

        String performReplace(String a) {
            int strLen = a.length();
            StringBuffer buf = new StringBuffer(strLen);
            for (int i = 0; i < strLen; ++i) {
                char ch = a.charAt(i);
                if (ch != '\\' && ch != '$') {
                    buf.append(ch);
                    continue;
                }
                if (ch == '\\') {
                    if (++i == strLen) {
                        buf.append('\\');
                        break;
                    }
                    ch = a.charAt(i);
                    buf.append(ch);
                    continue;
                }
                if (ch != '$') continue;
                if (++i == strLen) {
                    buf.append('$');
                    break;
                }
                ch = a.charAt(i);
                if (ch == '{') {
                    int j = a.indexOf(125, i);
                    if (j < 0) {
                        buf.append("${");
                        continue;
                    }
                    buf.append(this.get(a.substring(i + 1, j)));
                    i = j;
                    continue;
                }
                if (ch >= '0' && ch <= '9') {
                    int num = ch - 48;
                    ++i;
                    while (i < strLen) {
                        ch = a.charAt(i);
                        if (ch < '0' || ch > '9') {
                            --i;
                            break;
                        }
                        num = num * 10 + (ch - 48);
                        ++i;
                    }
                    buf.append(this.get(this.defaultKey, num));
                    continue;
                }
                buf.append('$');
                buf.append(ch);
            }
            return buf.toString();
        }
    }
}

