/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SSLEngineHelper;
import net.handle.hdllib.Util;

public class SignedInputStream
extends FilterInputStream {
    public static final int STREAM_TYPE_PK = 0;
    public static final int STREAM_TYPE_UNSIGNED = -1;
    public static final int STREAM_TYPE_TLS = 1414288128;
    private Signature sig;
    private final int streamType;

    public SignedInputStream(PublicKey sourceKey, InputStream in, Socket socket) throws Exception {
        super(in);
        byte[] streamTypeBuf = new byte[4];
        Util.readFully(in, streamTypeBuf);
        this.streamType = Encoder.readInt(streamTypeBuf, 0);
        switch (this.streamType) {
            case -1: {
                break;
            }
            case 0: {
                byte[] lenbuf = new byte[4];
                Util.readFully(in, lenbuf);
                int hashIDLen = Encoder.readInt(lenbuf, 0);
                if (hashIDLen < 0 || hashIDLen > 0x100000) {
                    throw new SignatureException("Invalid hash ID - too long");
                }
                byte[] hashID = new byte[hashIDLen];
                Util.readFully(in, hashID);
                this.sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashID, sourceKey.getAlgorithm()));
                this.sig.initVerify(sourceKey);
                break;
            }
            case 1414288128: {
                if (socket == null) {
                    throw new HandleException(10, "TLS stream not available");
                }
                SSLContext sslContext = SSLEngineHelper.getClientSSLContext(sourceKey);
                SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(socket, socket.getRemoteSocketAddress().toString(), socket.getPort(), true);
                sslSocket.setEnabledCipherSuites(SSLEngineHelper.ENABLED_CIPHER_SUITES);
                sslSocket.setEnabledProtocols(SSLEngineHelper.ENABLED_CLIENT_PROTOCOLS);
                sslSocket.setUseClientMode(true);
                this.in = new BufferedInputStream(sslSocket.getInputStream());
                break;
            }
            default: {
                throw new SignatureException("Unrecognized stream type: " + this.streamType);
            }
        }
    }

    public boolean isSecure() {
        return this.streamType != -1;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            return b;
        }
        if (this.streamType == 0) {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r <= 0) {
            return r;
        }
        if (this.streamType == 0) {
            try {
                this.sig.update(b, 0, r);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r <= 0) {
            return r;
        }
        if (this.streamType == 0) {
            try {
                this.sig.update(b, off, r);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        return r;
    }

    public boolean verifyBlock() throws IOException, SignatureException {
        int n;
        int r;
        if (this.streamType != 0) {
            return true;
        }
        byte[] lenbuf = new byte[4];
        for (n = 0; n < lenbuf.length && (r = this.in.read(lenbuf, n, lenbuf.length - n)) > 0; n += r) {
        }
        if (n < 4) {
            throw new SignatureException("End of stream while reading signature length");
        }
        int sigLen = Encoder.readInt(lenbuf, 0);
        if (sigLen < 0 || sigLen > 0x100000) {
            throw new SignatureException("Invalid signature - too long");
        }
        byte[] buf = new byte[sigLen];
        for (n = 0; n < sigLen && (r = this.in.read(buf, n, sigLen - n)) > 0; n += r) {
        }
        if (n < sigLen) {
            throw new SignatureException("End of stream while reading signature.  Expected " + sigLen + ",  got " + n);
        }
        return this.sig.verify(buf);
    }
}

