/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.util.AutoSelfSignedKeyManager;
import net.handle.util.TrustManagerSpecificPublicKey;

public class SSLEngineHelper {
    public static final String[] ENABLED_SERVER_PROTOCOLS;
    public static final String[] ENABLED_CLIENT_PROTOCOLS;
    public static final String[] ENABLED_CIPHER_SUITES;
    public static final String[] COMPATIBILITY_CIPHER_SUITES;
    private static final String[] DESIRED_CIPHER_SUITES;
    private static final String[] COMPATIBILITY_ONLY_CIPHER_SUITES;

    private static String[] getSupportedProtocols() {
        SSLContext context = SSLEngineHelper.getAllTrustingClientSSLContext();
        return context.getSupportedSSLParameters().getProtocols();
    }

    public static SSLContext getServerSSLContext(X509Certificate cert, PrivateKey privateKey) throws KeyManagementException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManager[] km = new KeyManager[]{new AutoSelfSignedKeyManager(null, cert, privateKey)};
            sslContext.init(km, null, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SSLContext getClientSSLContext(PublicKey publicKey) throws KeyManagementException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new TrustManagerSpecificPublicKey(Util.getBytesFromPublicKey(publicKey))};
            sslContext.init(null, tm, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (HandleException e) {
            throw new KeyManagementException(e.getMessage(), e);
        }
    }

    public static SSLContext getClientSSLContext(byte[] publicKey) throws KeyManagementException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new TrustManagerSpecificPublicKey(publicKey)};
            sslContext.init(null, tm, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SSLEngine getSSLEngine(SSLContext sslContext, boolean clientMode) {
        SSLEngine engine = sslContext.createSSLEngine();
        engine.setEnabledCipherSuites(ENABLED_CIPHER_SUITES);
        engine.setEnabledProtocols(clientMode ? ENABLED_CLIENT_PROTOCOLS : ENABLED_SERVER_PROTOCOLS);
        engine.setUseClientMode(clientMode);
        return engine;
    }

    public static SSLContext getAllTrustingClientSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new AllTrustingTrustManager()};
            sslContext.init(null, tm, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        DESIRED_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"};
        COMPATIBILITY_ONLY_CIPHER_SUITES = new String[]{"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA"};
        SSLContext context = SSLEngineHelper.getAllTrustingClientSSLContext();
        String[] supportedCipherSuitesArray = context.getSupportedSSLParameters().getCipherSuites();
        List<String> supportedCipherSuites = Arrays.asList(supportedCipherSuitesArray);
        ArrayList<String> enabledCipherSuites = new ArrayList<String>(Arrays.asList(DESIRED_CIPHER_SUITES));
        for (String tlsSuite : DESIRED_CIPHER_SUITES) {
            enabledCipherSuites.add(tlsSuite.replaceFirst("TLS", "SSL"));
        }
        enabledCipherSuites.retainAll(supportedCipherSuites);
        ENABLED_CIPHER_SUITES = enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]);
        ArrayList<String> compatibilityOnlyCipherSuites = new ArrayList<String>(Arrays.asList(COMPATIBILITY_ONLY_CIPHER_SUITES));
        for (String tlsSuite : COMPATIBILITY_ONLY_CIPHER_SUITES) {
            compatibilityOnlyCipherSuites.add(tlsSuite.replaceFirst("TLS", "SSL"));
        }
        compatibilityOnlyCipherSuites.retainAll(supportedCipherSuites);
        ArrayList<String> compatibilityCipherSuites = new ArrayList<String>(enabledCipherSuites);
        compatibilityCipherSuites.addAll(compatibilityOnlyCipherSuites);
        COMPATIBILITY_CIPHER_SUITES = compatibilityCipherSuites.toArray(new String[compatibilityCipherSuites.size()]);
        String[] supportedProtocols = SSLEngineHelper.getSupportedProtocols();
        ArrayList<String> serverProtocols = new ArrayList<String>();
        ArrayList<String> clientProtocols = new ArrayList<String>();
        for (String protocol : supportedProtocols) {
            if ("SSLv3".equals(protocol)) continue;
            serverProtocols.add(protocol);
            if ("SSLv2Hello".equals(protocol)) continue;
            clientProtocols.add(protocol);
        }
        ENABLED_CLIENT_PROTOCOLS = clientProtocols.toArray(new String[clientProtocols.size()]);
        ENABLED_SERVER_PROTOCOLS = serverProtocols.toArray(new String[serverProtocols.size()]);
    }

    private static class AllTrustingTrustManager
    implements X509TrustManager {
        private AllTrustingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static class SocketFactoryWrapper
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final boolean clientMode;

        public SocketFactoryWrapper(SSLSocketFactory delegate, boolean clientMode) {
            this.delegate = delegate;
            this.clientMode = clientMode;
        }

        private Socket fix(Socket s) {
            if (s instanceof SSLSocket) {
                ((SSLSocket)s).setEnabledProtocols(this.clientMode ? ENABLED_CLIENT_PROTOCOLS : ENABLED_SERVER_PROTOCOLS);
                ((SSLSocket)s).setEnabledCipherSuites(ENABLED_CIPHER_SUITES);
            }
            return s;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.fix(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.fix(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.fix(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.fix(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.fix(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.fix(this.delegate.createSocket(host, port));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

