/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import net.cnri.util.FastDateFormat;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValue {
    public static final byte SUBTYPE_SEPARATOR = 46;
    public static final byte TTL_TYPE_RELATIVE = 0;
    public static final byte TTL_TYPE_ABSOLUTE = 1;
    public static final int MAX_RECOGNIZED_TTL = 172800;
    int index = -1;
    byte[] type = Common.EMPTY_BYTE_ARRAY;
    byte[] data = Common.EMPTY_BYTE_ARRAY;
    byte ttlType = 0;
    int ttl = 86400;
    int timestamp = 0;
    ValueReference[] references = null;
    boolean adminRead = true;
    boolean adminWrite = true;
    boolean publicRead = true;
    boolean publicWrite = false;
    byte[] cachedBuf = null;
    int cachedBufOffset = 0;
    int cachedBufLength = 0;
    private static FastDateFormat format = new FastDateFormat(new FastDateFormat.FormatSpec("-", " ", ":", ":", ".", false, true), null);
    public static Comparator<HandleValue> INDEX_COMPARATOR = (v1, v2) -> {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1.getIndex() < v2.getIndex()) {
            return -1;
        }
        if (v1.getIndex() == v2.getIndex()) {
            return 0;
        }
        return 1;
    };

    public HandleValue() {
    }

    public HandleValue(int index, byte[] type, byte[] data) {
        this.index = index;
        this.type = type;
        this.data = data;
    }

    public HandleValue(int index, String type, byte[] data) {
        this.index = index;
        this.type = Util.encodeString(type);
        this.data = data;
    }

    public HandleValue(int index, String type, String data) {
        this.index = index;
        this.type = Util.encodeString(type);
        this.data = Util.encodeString(data);
    }

    public HandleValue(int index, byte[] type, byte[] data, byte ttlType, int ttl, int timestamp, ValueReference[] references, boolean adminRead, boolean adminWrite, boolean publicRead, boolean publicWrite) {
        this.index = index;
        this.type = type;
        this.data = data;
        this.ttlType = ttlType;
        this.ttl = ttl;
        this.timestamp = timestamp;
        this.references = references;
        this.adminRead = adminRead;
        this.adminWrite = adminWrite;
        this.publicRead = publicRead;
        this.publicWrite = publicWrite;
    }

    public final String getPermissionString() {
        return new String(new char[]{this.adminRead ? (char)'r' : '-', this.adminWrite ? (char)'w' : '-', this.publicRead ? (char)'r' : '-', this.publicWrite ? (char)'w' : '-'});
    }

    public String toDetailedString() {
        return " index=" + this.index + " type=" + (this.type == null ? "" : Util.decodeString(this.type)) + " " + this.getPermissionString() + " ttl=" + this.ttlType + "/" + this.ttl + " timestamp=" + FastDateFormat.formatUtc((FastDateFormat.FormatSpec)FastDateFormat.FormatSpec.ISO8601_NO_MS, (long)(1000L * (long)this.timestamp)) + " \"" + (this.data == null ? "" : (Util.looksLikeBinary(this.data) ? Util.decodeHexString(this.data, false) : Util.decodeString(this.data))) + '\"';
    }

    public String toString() {
        return " index=" + this.index + " type=" + (this.type == null ? "" : Util.decodeString(this.type)) + " " + this.getPermissionString() + " \"" + (this.data == null ? "" : (Util.looksLikeBinary(this.data) ? Util.decodeHexString(this.data, false) : Util.decodeString(this.data))) + '\"';
    }

    public boolean isExpired(int now, int timeRetrieved) {
        switch (this.ttlType) {
            case 0: {
                return this.ttl == 0 || Math.min(this.ttl, 172800) < now - timeRetrieved;
            }
            case 1: {
                return 172800 > now - timeRetrieved || this.ttl < now;
            }
        }
        return true;
    }

    public final boolean hasType(byte[] someType) {
        return Util.equalsCI(this.type, someType) || someType.length < this.type.length && this.type[someType.length] == 46 && Util.startsWithCI(this.type, someType);
    }

    public final String getDataAsString() {
        if (this.data == null) {
            return "";
        }
        if (Util.looksLikeBinary(this.data)) {
            return Util.decodeHexString(this.data, false);
        }
        return Util.decodeString(this.data);
    }

    public final String getTypeAsString() {
        return this.type == null ? "" : Util.decodeString(this.type);
    }

    public final String getTimestampAsString() {
        return this.timestamp <= 0 ? "NA" : new Date((long)this.timestamp * 1000L).toString();
    }

    public final String getNicerTimestampAsString() {
        if (this.timestamp < 0) {
            return "NA";
        }
        return format.format(1000L * (long)this.timestamp);
    }

    public final Date getTimestampAsDate() {
        return this.timestamp <= 0 ? null : new Date((long)this.timestamp * 1000L);
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int newIndex) {
        this.index = newIndex;
        this.cachedBuf = null;
    }

    public final byte[] getType() {
        return this.type;
    }

    public final void setType(byte[] newType) {
        this.type = newType;
        this.cachedBuf = null;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] newData) {
        this.data = newData;
        this.cachedBuf = null;
    }

    public final byte getTTLType() {
        return this.ttlType;
    }

    public final void setTTLType(byte newTTLType) {
        this.ttlType = newTTLType;
        this.cachedBuf = null;
    }

    public final int getTTL() {
        return this.ttl;
    }

    public final void setTTL(int newTTL) {
        this.ttl = newTTL;
        this.cachedBuf = null;
    }

    public final int getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(int newTimestamp) {
        this.timestamp = newTimestamp;
    }

    public final ValueReference[] getReferences() {
        return this.references;
    }

    public final void setReferences(ValueReference[] newReferences) {
        this.references = newReferences;
        this.cachedBuf = null;
    }

    public final boolean getAdminCanRead() {
        return this.adminRead;
    }

    public final void setAdminCanRead(boolean newAdminRead) {
        this.adminRead = newAdminRead;
        this.cachedBuf = null;
    }

    public final boolean getAdminCanWrite() {
        return this.adminWrite;
    }

    public final void setAdminCanWrite(boolean newAdminWrite) {
        this.adminWrite = newAdminWrite;
        this.cachedBuf = null;
    }

    public final boolean getAnyoneCanRead() {
        return this.publicRead;
    }

    public final void setAnyoneCanRead(boolean newPublicRead) {
        this.publicRead = newPublicRead;
        this.cachedBuf = null;
    }

    public final boolean getAnyoneCanWrite() {
        return this.publicWrite;
    }

    public final void setAnyoneCanWrite(boolean newPublicWrite) {
        this.publicWrite = newPublicWrite;
        this.cachedBuf = null;
    }

    public HandleValue duplicate() {
        ValueReference[] newRefs = null;
        ValueReference[] myRefs = this.references;
        if (myRefs != null) {
            newRefs = new ValueReference[myRefs.length];
            for (int i = 0; i < newRefs.length; ++i) {
                newRefs[i] = new ValueReference(myRefs[i].handle, myRefs[i].index);
            }
        }
        return new HandleValue(this.index, Util.duplicateByteArray(this.type), Util.duplicateByteArray(this.data), this.ttlType, this.ttl, this.timestamp, newRefs, this.adminRead, this.adminWrite, this.publicRead, this.publicWrite);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminRead ? 1231 : 1237);
        result = 31 * result + (this.adminWrite ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.index;
        result = 31 * result + (this.publicRead ? 1231 : 1237);
        result = 31 * result + (this.publicWrite ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(HandleValue.emptyToNull(this.references));
        result = 31 * result + this.timestamp;
        result = 31 * result + this.ttl;
        result = 31 * result + this.ttlType;
        result = 31 * result + Arrays.hashCode(this.type);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandleValue other = (HandleValue)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.equalsIgnoreTimestamp(other);
    }

    public boolean equalsIgnoreTimestamp(HandleValue other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.adminRead != other.adminRead) {
            return false;
        }
        if (this.adminWrite != other.adminWrite) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.publicRead != other.publicRead) {
            return false;
        }
        if (this.publicWrite != other.publicWrite) {
            return false;
        }
        if (!Arrays.equals(HandleValue.emptyToNull(this.references), HandleValue.emptyToNull(other.references))) {
            return false;
        }
        if (this.ttl != other.ttl) {
            return false;
        }
        if (this.ttlType != other.ttlType) {
            return false;
        }
        return Arrays.equals(this.type, other.type);
    }

    private static <T> T[] emptyToNull(T[] array) {
        if (array != null && array.length == 0) {
            return null;
        }
        return array;
    }

    public static boolean unorderedEquals(HandleValue[] vals1, HandleValue[] vals2) {
        if (vals1 == null && vals2 == null) {
            return true;
        }
        if (vals1 == null || vals2 == null) {
            return false;
        }
        if (vals1.length != vals2.length) {
            return false;
        }
        ArrayList<HandleValue> vals1List = new ArrayList<HandleValue>(vals1.length);
        for (HandleValue val : vals1) {
            vals1List.add(val);
        }
        ArrayList<HandleValue> vals2List = new ArrayList<HandleValue>(vals2.length);
        for (HandleValue val : vals2) {
            vals2List.add(val);
        }
        Collections.sort(vals1List, INDEX_COMPARATOR);
        Collections.sort(vals2List, INDEX_COMPARATOR);
        return vals1List.equals(vals2List);
    }

    public static boolean unorderedEqualsIgnoreTimestamp(HandleValue[] vals1, HandleValue[] vals2) {
        if (vals1 == null && vals2 == null) {
            return true;
        }
        if (vals1 == null || vals2 == null) {
            return false;
        }
        if (vals1.length != vals2.length) {
            return false;
        }
        ArrayList<HandleValue> vals1List = new ArrayList<HandleValue>(vals1.length);
        for (HandleValue val : vals1) {
            vals1List.add(val);
        }
        ArrayList<HandleValue> vals2List = new ArrayList<HandleValue>(vals2.length);
        for (HandleValue val : vals2) {
            vals2List.add(val);
        }
        Collections.sort(vals1List, INDEX_COMPARATOR);
        Collections.sort(vals2List, INDEX_COMPARATOR);
        for (int i = 0; i < vals1.length; ++i) {
            if (((HandleValue)vals1List.get(i)).equalsIgnoreTimestamp((HandleValue)vals2List.get(i))) continue;
            return false;
        }
        return true;
    }
}

