/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.cnri.io.AtomicFile;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamUtil;
import net.cnri.util.StreamVector;
import net.handle.apps.simple.LocalInfoConverter;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.BootstrapHandles;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.SiteFilter;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class FilesystemConfiguration
extends Configuration {
    public static final String AUTO_UPDATE_ROOT_INFO = "auto_update_root_info";
    @Deprecated
    private static final String PREFERRED_ROOT = "preferred_root";
    public static final String PREFERRED_GLOBAL_SERVICE_HANDLE = "preferred_global_service_handle";
    public static final String SITE_FILTER_KEYWORDS_ATT_NAME = "site_filter_keywords";
    private HandleValue[] globalValues = null;
    private SiteInfo[] globalSites = null;
    private NamespaceInfo globalNamespace = null;
    private File globalValuesFile = null;
    private File bootstrapHandlesFile = null;
    private HandleValue[] cacheValues = null;
    private SiteInfo[] cacheSites = null;
    private boolean useCacheSitesForAll = false;
    private Map<String, SiteInfo[]> localSites = null;
    private Map<String, InetAddress> localAddresses = null;
    private int resolutionMethod = 0;
    private File configDir = null;
    private final StreamTable configTable = new StreamTable();
    private BootstrapHandles bootstrapHandles;
    private List<PublicKey> rootKeys;

    FilesystemConfiguration() {
        try {
            String configDirName = System.getProperty("net.handle.configDir");
            this.configDir = configDirName != null ? new File(configDirName) : FilesystemConfiguration.getDefaultConfigDir();
            this.configDir.mkdirs();
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Had trouble finding your \"home\" directory and/or your configuration settings.  Will use \"" + this.configDir + ".\"  ");
        }
    }

    public static File getDefaultConfigDir() {
        String userDirName = System.getProperty("user.home");
        File userDir = userDirName == null ? new File(System.getProperty("user.dir", File.separator)) : new File(FilesystemConfiguration.fixVariablesIfWindows(userDirName));
        return new File(userDir, ".handle");
    }

    public FilesystemConfiguration(File configDir) {
        this.configDir = configDir;
        this.init();
    }

    private void init() {
        this.loadConfigDct();
        this.loadResolverServiceFile();
        this.loadResolverSiteFile();
        this.loadLocalNasFile();
        this.loadLocalInfoFile();
        this.loadLocalAddressesFile();
        this.loadBootstrapHandles();
    }

    private void loadConfigDct() {
        try {
            File configFile = new File(this.configDir, "config.dct");
            if (configFile.exists()) {
                try {
                    this.configTable.readFromFile(configFile);
                }
                catch (Exception e) {
                    System.err.println("Error reading configuration: " + e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Error loading config.dct");
        }
    }

    private synchronized void loadBootstrapHandles() {
        boolean loadSuccess = false;
        try {
            this.globalValuesFile = new File(this.configDir, "root_info");
            this.bootstrapHandlesFile = new File(this.configDir, "bootstrap_handles");
            AtomicFile bootstrapHandlesAtomicFile = new AtomicFile(this.bootstrapHandlesFile);
            if (bootstrapHandlesAtomicFile.exists()) {
                String bootstrapHandlesJson = Util.decodeString(bootstrapHandlesAtomicFile.readFully());
                BootstrapHandles newBootstrapHandles = (BootstrapHandles)GsonUtility.getGson().fromJson(bootstrapHandlesJson, BootstrapHandles.class);
                this.setBootstrapHandles(newBootstrapHandles);
                loadSuccess = true;
                if (this.getPreferredGlobalServiceHandle() != null && !this.getBootstrapHandles().handles.containsKey(this.getPreferredGlobalServiceHandle()) && this.isAutoUpdateRootInfo()) {
                    this.bootstrapHandles.lastUpdate = 0L;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading bootstrap_handles, trying default");
            e.printStackTrace(System.err);
        }
        if (!loadSuccess) {
            try {
                this.loadDefaultBootstrapHandles();
                loadSuccess = true;
            }
            catch (Exception e) {
                System.err.println("Error loading default bootstrap_handles!");
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultBootstrapHandles() throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/net/handle/etc/bootstrap_handles");
        try {
            String bootstrapHandlesJson = Util.decodeString(StreamUtil.readFully((InputStream)in));
            BootstrapHandles newBootstrapHandles = (BootstrapHandles)GsonUtility.getGson().fromJson(bootstrapHandlesJson, BootstrapHandles.class);
            this.setBootstrapHandles(newBootstrapHandles);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResolverServiceFile() {
        try {
            File cacheValuesFile = new File(this.configDir, "resolver_service");
            if (cacheValuesFile.exists() && cacheValuesFile.canRead()) {
                FileInputStream in = new FileInputStream(cacheValuesFile);
                try {
                    this.cacheValues = Encoder.decodeGlobalValues(in);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.cacheValues != null) {
                this.cacheSites = Util.getSitesAndAltSitesFromValues(this.cacheValues);
                if (this.cacheSites != null && this.cacheSites.length > 0) {
                    this.resolutionMethod = 1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Unable to load local cache/resolver service information:  " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResolverSiteFile() {
        block12: {
            try {
                File cacheSiteFile;
                if (this.cacheSites != null && this.cacheSites.length > 0 || !(cacheSiteFile = new File(this.configDir, "resolver_site")).exists() || !cacheSiteFile.canRead()) break block12;
                FileInputStream in = new FileInputStream(cacheSiteFile);
                try {
                    int r;
                    byte[] siteBuf = new byte[(int)cacheSiteFile.length()];
                    for (int n = 0; n < siteBuf.length && (r = in.read(siteBuf, n, siteBuf.length - n)) >= 0; n += r) {
                    }
                    SiteInfo cacheSite = new SiteInfo();
                    if (Util.looksLikeBinary(siteBuf)) {
                        Encoder.decodeSiteInfoRecord(siteBuf, 0, cacheSite);
                    } else {
                        cacheSite = SiteInfoConverter.convertToSiteInfo(new String(siteBuf, "UTF-8"));
                    }
                    SiteInfo altCacheSite = Util.getAltSiteInfo(cacheSite);
                    this.cacheSites = altCacheSite != null ? new SiteInfo[]{cacheSite, altCacheSite} : new SiteInfo[]{cacheSite};
                    this.resolutionMethod = 1;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("Unable to load local cache/resolver site information.  Will use global resolution");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalNasFile() {
        block9: {
            try {
                File localNAFile;
                if (this.cacheSites == null || this.cacheSites.length <= 0 || !(localNAFile = new File(this.configDir, "local_nas")).exists() || !localNAFile.canRead()) break block9;
                try (BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(localNAFile), "UTF8"));){
                    String line;
                    while ((line = rdr.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        if ("*".equals(line)) {
                            this.useCacheSitesForAll = true;
                            continue;
                        }
                        if (this.localSites == null) {
                            this.localSites = new HashMap<String, SiteInfo[]>();
                        }
                        this.localSites.put(line.toUpperCase(Locale.ENGLISH).trim(), this.cacheSites);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("Error loading local prefix list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalInfoFile() {
        block17: {
            File localSitesFile = new File(this.configDir, "local_info");
            if (!localSitesFile.exists()) {
                localSitesFile = new File(this.configDir, "local_info.json");
            }
            InputStream localSitesIn = null;
            try {
                if (localSitesFile.exists() && localSitesFile.canRead()) {
                    try {
                        localSitesIn = Files.newInputStream(localSitesFile.toPath(), new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (localSitesIn == null && (localSitesIn = this.getClass().getResourceAsStream("/net/handle/etc/local_info")) == null) {
                    localSitesIn = this.getClass().getResourceAsStream("/net/handle/etc/local_info.json");
                }
                if (localSitesIn == null) break block17;
                try {
                    byte[] bytes = StreamUtil.readFully((InputStream)localSitesIn);
                    if (Util.looksLikeBinary(bytes)) {
                        this.localSites = Encoder.decodeLocalSites(new ByteArrayInputStream(bytes));
                        break block17;
                    }
                    this.localSites = LocalInfoConverter.convertFromJson(Util.decodeString(bytes));
                }
                catch (Exception e) {
                    System.err.println("Error reading " + localSitesFile.getPath());
                }
            }
            finally {
                if (localSitesIn != null) {
                    try {
                        localSitesIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.localSites == null) {
            this.localSites = new HashMap<String, SiteInfo[]>(0);
        }
    }

    private void loadLocalAddressesFile() {
        File localAddressesFile = new File(this.configDir, "local_addresses");
        if (localAddressesFile.exists() && localAddressesFile.canRead()) {
            try (FileInputStream fi = new FileInputStream(localAddressesFile);){
                this.setLocalAddressMap(Encoder.decodeLocalAddresses(fi));
            }
            catch (Exception e) {
                System.err.println("Error reading local address map: " + e);
                e.printStackTrace(System.err);
                this.setLocalAddressMap(null);
            }
        }
    }

    @Override
    public void configureResolver(HandleResolver resolver) {
        FilesystemConfiguration.configureResolverUsingKeys(resolver, this.configTable);
    }

    public static void configureResolverUsingKeys(HandleResolver resolver, StreamTable configTable) {
        if (configTable.containsKey("tcp_timeout")) {
            int timeout = Integer.parseInt((String)configTable.get("tcp_timeout"));
            resolver.setTcpTimeout(timeout);
        }
        boolean bl = resolver.traceMessages = configTable.getBoolean("trace_resolution") || configTable.getBoolean("trace_outgoing_messages");
        if (configTable.getBoolean("no_udp_resolution", false)) {
            resolver.setPreferredProtocols(new int[]{1, 2});
        }
        if (configTable.containsKey(SITE_FILTER_KEYWORDS_ATT_NAME)) {
            Object obj = configTable.get(SITE_FILTER_KEYWORDS_ATT_NAME);
            if (obj instanceof StreamVector) {
                StreamVector keywordVector = (StreamVector)obj;
                resolver.setSiteFilter(new KeywordSiteFilter(FilesystemConfiguration.asStringArray(keywordVector)));
            } else {
                resolver.setSiteFilter(new KeywordSiteFilter(FilesystemConfiguration.splitAtWhitespace(String.valueOf(obj))));
            }
        }
        if (configTable.containsKey("ipv6_fast_fallback")) {
            resolver.setUseIPv6FastFallback(configTable.getBoolean("ipv6_fast_fallback", true));
        }
    }

    private static String[] asStringArray(StreamVector keywordVector) {
        String[] res = new String[keywordVector.size()];
        int i = 0;
        for (Object obj : keywordVector) {
            res[i] = (String)obj;
        }
        return res;
    }

    static String[] splitAtWhitespace(String s) {
        return s.trim().split("\\s++");
    }

    @Override
    public void setLocalSites(String na, SiteInfo[] sites) {
        this.localSites.put(na.toUpperCase(Locale.ENGLISH), sites);
    }

    @Override
    public synchronized void setLocalAddressMap(Map<String, String> localAddrMap) {
        if (localAddrMap == null) {
            this.localAddresses = null;
        } else {
            HashMap<String, InetAddress> tmp = new HashMap<String, InetAddress>();
            for (String key : localAddrMap.keySet()) {
                String val;
                if (key == null || (val = localAddrMap.get(key)) == null) continue;
                try {
                    tmp.put(key, InetAddress.getByName(String.valueOf(val)));
                }
                catch (Exception e) {
                    System.err.println("Invalid local address: " + key + " -> " + val);
                }
            }
            this.localAddresses = tmp;
        }
    }

    static String fixVariablesIfWindows(String s) {
        if (!System.getProperty("os.name", "").startsWith("Windows")) {
            return s;
        }
        return FilesystemConfiguration.fixForWindows(s);
    }

    static String fixForWindows(String s) {
        int end;
        int start = s.indexOf(37);
        if (start < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (start >= 0 && (end = sb.indexOf("%", start + 1)) >= 0) {
            String var = sb.substring(start + 1, end);
            String value = System.getenv(var);
            if (value == null) {
                value = FilesystemConfiguration.getenvCaseInsensitive(var);
            }
            sb.replace(start, end + 1, value);
            start = sb.indexOf("%", end + 1);
        }
        return sb.toString();
    }

    static String getenvCaseInsensitive(String var) {
        for (String name : System.getenv().keySet()) {
            if (!name.equalsIgnoreCase(var)) continue;
            return System.getenv(name);
        }
        return null;
    }

    @Override
    public synchronized void saveLocalAddressMap() throws IOException {
        Map<String, String> localAddr = this.getLocalAddressMap();
        File localAddressesFile = new File(this.configDir, "local_addresses");
        if (localAddr == null) {
            if (localAddressesFile.exists()) {
                localAddressesFile.delete();
            }
        } else {
            try (FileOutputStream fo = new FileOutputStream(localAddressesFile);){
                Encoder.writeLocalAddresses(localAddr, fo);
            }
            catch (Exception e) {
                System.err.println("Error saving local address map: " + e);
            }
        }
    }

    @Override
    public synchronized Map<String, String> getLocalAddressMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, InetAddress> entry : this.localAddresses.entrySet()) {
            res.put(entry.getKey(), Util.rfcIpRepr(entry.getValue()));
        }
        return res;
    }

    @Override
    public InetAddress mapLocalAddress(InetAddress addr) {
        Map<String, InetAddress> local = this.localAddresses;
        if (local == null) {
            return addr;
        }
        InetAddress val = local.get(Util.rfcIpRepr(addr));
        if (val != null) {
            try {
                return val;
            }
            catch (Exception e) {
                System.err.println("Invalid address map: " + addr + " -> " + val);
            }
        }
        return addr;
    }

    @Override
    public SiteInfo[] getLocalSites(String na) {
        SiteInfo[] res = this.localSites.get(na.toUpperCase(Locale.ENGLISH));
        if (res == null && this.useCacheSitesForAll) {
            return this.cacheSites;
        }
        return res;
    }

    @Override
    @Deprecated
    public synchronized void setGlobalValues(HandleValue[] globalValues) {
        this.globalValues = globalValues;
        this.globalNamespace = Util.getNamespaceFromValues(globalValues);
        SiteInfo[] newSites = Util.getSitesAndAltSitesFromValues(globalValues);
        if (newSites != null) {
            this.setGlobalSites(newSites);
        }
    }

    public void setGlobalValuesFile(File newGlobalValuesFile) {
        this.globalValuesFile = newGlobalValuesFile;
    }

    @Override
    public void setBootstrapHandles(BootstrapHandles bootstrapHandles) {
        this.bootstrapHandles = bootstrapHandles;
        Set<SiteInfo> sites = bootstrapHandles.getSites(this.getPreferredGlobalServiceHandle());
        if (sites != null && !sites.isEmpty()) {
            this.setGlobalSites(sites.toArray(new SiteInfo[sites.size()]));
        } else if (this.getPreferredGlobalServiceHandle() != null && (sites = bootstrapHandles.getSites(null)) != null && !sites.isEmpty()) {
            System.err.println("No sites at preferred global service handle " + this.getPreferredGlobalServiceHandle() + ", using 0.NA/0.NA");
            this.setGlobalSites(sites.toArray(new SiteInfo[sites.size()]));
        }
        if (sites == null || sites.isEmpty()) {
            System.err.println("No global sites found!");
        }
        HandleRecord rootOfResolution = this.bootstrapHandles.handles.get("0.NA/0.NA");
        this.globalValues = rootOfResolution.getValuesAsArray();
        this.globalNamespace = Util.getNamespaceFromValues(rootOfResolution.getValuesAsArray());
        HandleRecord trustRoot = this.bootstrapHandles.handles.get("0.0/0.0");
        List<PublicKey> rootKeys = Util.getPublicKeysFromValues(trustRoot.getValuesAsArray());
        if (rootKeys != null && !rootKeys.isEmpty()) {
            this.setRootKeys(rootKeys);
        }
    }

    @Override
    public synchronized void persist() {
        try {
            new AtomicFile(this.globalValuesFile).writeFully(Encoder.encodeGlobalValues(this.globalValues));
        }
        catch (Exception e) {
            System.err.println("Error saving global values to: " + this.globalValuesFile);
            e.printStackTrace();
        }
        System.err.println("Saving bootstrap handles to: " + this.bootstrapHandlesFile);
        try {
            String bootstrapHandlesJson = GsonUtility.getPrettyGson().toJson((Object)this.bootstrapHandles);
            new AtomicFile(this.bootstrapHandlesFile).writeFully(Util.encodeString(bootstrapHandlesJson));
        }
        catch (Exception e) {
            System.err.println("Error saving bootstrap handles values to: " + this.bootstrapHandlesFile);
            e.printStackTrace();
        }
    }

    public void setConfigDir(File newConfigDir) {
        this.configDir = newConfigDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    @Override
    public HandleValue[] getGlobalValues() {
        return this.globalValues;
    }

    @Override
    public NamespaceInfo getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    public void setGlobalSites(SiteInfo[] globalSites) {
        this.globalSites = globalSites;
        for (int i = this.globalSites.length - 1; i >= 0; --i) {
            this.globalSites[i].isRoot = true;
        }
    }

    @Override
    public SiteInfo[] getGlobalSites() {
        return this.globalSites;
    }

    @Override
    public void setCacheSites(SiteInfo[] cacheSites) {
        this.cacheSites = cacheSites;
    }

    @Override
    public SiteInfo[] getCacheSites() {
        return this.cacheSites;
    }

    @Override
    public int getResolutionMethod() {
        return this.resolutionMethod;
    }

    @Override
    public void setResolutionMethod(int resolutionMethod) {
        this.resolutionMethod = resolutionMethod;
    }

    @Override
    public boolean isAutoUpdateRootInfo() {
        return this.configTable.getBoolean(AUTO_UPDATE_ROOT_INFO, true);
    }

    @Override
    public void setAutoUpdateRootInfo(boolean enabled) {
        this.configTable.put(AUTO_UPDATE_ROOT_INFO, enabled);
    }

    @Override
    public String getPreferredGlobalServiceHandle() {
        String res = this.configTable.getStr(PREFERRED_GLOBAL_SERVICE_HANDLE, null);
        if (res != null) {
            return res;
        }
        return this.configTable.getStr(PREFERRED_ROOT, null);
    }

    @Override
    public List<PublicKey> getRootKeys() {
        return this.rootKeys;
    }

    @Override
    public void setRootKeys(List<PublicKey> rootKeys) {
        this.rootKeys = rootKeys;
    }

    @Override
    public BootstrapHandles getBootstrapHandles() {
        return this.bootstrapHandles;
    }

    private static class KeywordSiteFilter
    implements SiteFilter {
        List<String> keywords;

        public KeywordSiteFilter(String[] keywords) {
            this.keywords = Arrays.asList(keywords);
        }

        @Override
        public boolean apply(SiteInfo site) {
            if (site.attributes == null) {
                return false;
            }
            ArrayList<String> thisSiteKeywords = new ArrayList<String>();
            for (Attribute att : site.attributes) {
                String[] thisAttKeywords;
                if (!FilesystemConfiguration.SITE_FILTER_KEYWORDS_ATT_NAME.equals(Util.decodeString(att.name))) continue;
                for (String keyword : thisAttKeywords = FilesystemConfiguration.splitAtWhitespace(Util.decodeString(att.value))) {
                    thisSiteKeywords.add(keyword);
                }
            }
            return !Collections.disjoint(this.keywords, thisSiteKeywords);
        }
    }
}

