/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.ClientSideSessionInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.Util;

public abstract class AbstractRequest
extends AbstractMessage {
    public byte[] handle;
    public boolean isAdminRequest = false;
    public boolean requiresConnection = false;
    public boolean multithread = false;
    public ReentrantLock connectionLock = new ReentrantLock();
    public AtomicBoolean completed = new AtomicBoolean();
    public AtomicReference<Socket> socketRef = new AtomicReference();
    public AuthenticationInfo authInfo = null;
    public ClientSideSessionInfo sessionInfo = null;
    public ClientSessionTracker sessionTracker = null;
    byte[] serverPubKeyBytes = null;
    public boolean streaming = false;
    private NamespaceInfo namespace = null;

    public AbstractRequest(byte[] handle, int opCode, AuthenticationInfo authInfo) {
        super(opCode);
        this.authInfo = authInfo;
        this.handle = handle;
        this.responseCode = 0;
    }

    @Override
    public AbstractRequest clone() {
        AbstractRequest req = (AbstractRequest)super.clone();
        req.socketRef = new AtomicReference<Socket>(this.socketRef.get());
        return req;
    }

    public NamespaceInfo getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceInfo namespace) {
        if (namespace != null) {
            namespace.setParentNamespace(this.namespace);
        }
        this.namespace = namespace;
    }

    public void setNamespaceExactly(NamespaceInfo namespace) {
        this.namespace = namespace;
    }

    @Override
    public void clearBuffers() {
        this.namespace = null;
        this.multithread = false;
        this.completed.set(false);
        this.socketRef.set(null);
        super.clearBuffers();
    }

    @Override
    public String toString() {
        return super.toString() + (this.isAdminRequest ? " adm" : "") + ' ' + Util.decodeString(this.handle);
    }

    public void signMessageForSession() throws HandleException {
        try {
            this.sessionCounter = this.sessionInfo.getNextSessionCounter();
            this.signMessage(this.sessionInfo.getSessionKey());
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(19, "Unable to sign original request with session key: ", e);
        }
    }

    void takeValuesFromRequestActuallyUsed(AbstractRequest req) {
        this.siteInfoSerial = req.siteInfoSerial;
        this.sessionInfo = req.sessionInfo;
        this.requestId = req.requestId;
        this.sessionId = req.sessionId;
        this.certify = req.certify;
        this.encrypt = req.encrypt;
        this.sessionCounter = req.sessionCounter;
        this.serverPubKeyBytes = req.serverPubKeyBytes;
        this.majorProtocolVersion = req.majorProtocolVersion;
        this.minorProtocolVersion = req.minorProtocolVersion;
        this.suggestMajorProtocolVersion = req.suggestMajorProtocolVersion;
        this.suggestMinorProtocolVersion = req.suggestMinorProtocolVersion;
        this.rdHashType = req.rdHashType;
        this.requestDigest = req.requestDigest;
        this.namespace = req.namespace;
    }
}

