/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.cnri.simplexml.XTag;
import net.cnri.util.StringUtils;
import net.handle.apps.servlet_proxy.HDLServletRequest;
import net.handle.apps.servlet_proxy.TypeHandler;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class Url
implements TypeHandler {
    static final byte[] zeroDotTypeUrl = new byte[]{48, 46, 84, 89, 80, 69, 47, 85, 82, 76};

    @Override
    public boolean canRedirect(HandleValue[] values) {
        if (values == null) {
            return false;
        }
        for (int i = values.length - 1; i >= 0; --i) {
            if (!values[i].hasType(Common.STD_TYPE_URL) && !values[i].hasType(zeroDotTypeUrl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canFormat(HandleValue value) {
        return value != null && (value.hasType(Common.STD_TYPE_URL) || value.hasType(zeroDotTypeUrl));
    }

    @Override
    public String toHTML(String handle, HandleValue value) {
        String data = StringUtils.cgiEscape((String)value.getDataAsString());
        return "<a href=\"" + data + "\">" + data + "</a>";
    }

    @Override
    public boolean doRedirect(HDLServletRequest req, HandleValue[] values) throws IOException {
        HandleValue val;
        if (values == null) {
            return false;
        }
        String redirectURL = null;
        for (HandleValue value : values) {
            byte[] valType;
            val = value;
            if (val == null || (valType = val.getType()) == null || !Util.equalsCI(valType, Common.STD_TYPE_URL) && !Util.equalsCI(valType, zeroDotTypeUrl)) continue;
            req.modifyExpiration(val);
            redirectURL = val.getDataAsString();
            break;
        }
        if (redirectURL == null) {
            for (HandleValue value : values) {
                val = value;
                if (val == null || !val.hasType(Common.STD_TYPE_URL) && !val.hasType(zeroDotTypeUrl)) continue;
                req.modifyExpiration(val);
                redirectURL = val.getDataAsString();
                break;
            }
        }
        if (redirectURL == null) {
            return false;
        }
        String urlSuffix = req.params.getParameter("urlappend");
        if (urlSuffix == null) {
            urlSuffix = "";
        }
        try {
            req.sendHTTPRedirect(HDLServletRequest.ResponseType.DEFAULT_RESPONSE_TYPE, redirectURL + urlSuffix);
            req.response.setContentType("text/html; charset=utf-8");
            String escapedURL = StringUtils.cgiEscape((String)(redirectURL + urlSuffix));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)req.response.getOutputStream(), "UTF-8");
            out.write("\n<HTML><HEAD><TITLE>Handle Redirect</TITLE></HEAD>");
            out.write("\n<BODY><A HREF=\"" + escapedURL + "\">");
            out.write(escapedURL + "</A></BODY></HTML>");
            out.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("Error in Url.doRedirect for " + req.hdl + ": " + e);
            return false;
        }
    }

    @Override
    public boolean canShowLocations(HandleValue[] values) {
        return false;
    }

    @Override
    public XTag doShowLocations(HDLServletRequest req, HandleValue[] values) throws Exception {
        return null;
    }
}

