/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletResponse;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.cnri.util.StringUtils;
import net.handle.apps.servlet_proxy.HDLServletRequest;
import net.handle.apps.servlet_proxy.TypeHandler;
import net.handle.apps.servlet_proxy.handlers.CIDRUtils;
import net.handle.apps.servlet_proxy.handlers.Url;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.Util;

public class Location
implements TypeHandler {
    public static final String LOCATIONS_TAG_NAME = "locations";
    public static final String CHOOSEBY_COUNTRY = "country";
    public static final String CHOOSEBY_WEIGHTED = "weighted";
    public static final String CHOOSEBY_LINKPARAM = "locatt";
    public static final String CHOOSEBY_ADDRESS = "address";
    public static final String CHOOSEBY_SCORE = "score";
    public static final String[] DEFAULT_CHOOSEBY = new String[]{"locatt", "address", "country", "score", "weighted"};
    public static final String CHOOSEBY_OLD_ATTRIBUTE = "chooseby";
    public static final String CHOOSEBY_ATTRIBUTE = "choose_by";
    public static final String SUPPRESS_LEGACY = "no_legacy";
    public static final String SUPPRESS_NAMESPACE_LOCS = "no_nslocs";
    public static final String ACCEPT_HEADER_STRING = "Accept";
    public static final String NSHDL_ATTRIBUTE = "nshdl";
    public static final String HDL_TEMPLATE_STRING = "{hdl}";
    public static final String HDL_PATH_TEMPLATE_STRING = "{hdl:path}";
    public static final String LOC_ATTRIBUTE = "href";
    public static final String LOC_TEMPLATE_ATTRIBUTE = "href_template";
    public static final String LOC_TAG_NAME = "location";
    public static final String OLD_LOC_TEMPLATE_TAG_NAME = "loc_template";
    public static final String REDIRECT_TYPE_ATT = "http_sc";
    public static final String WEIGHT_ATTRIBUTE = "weight";
    public static final String LOC_ATT_HTTP_ROLE = "http_role";
    public static final String LOC_ATT_VALUE_CONNEG = "conneg";
    public static final String ADDRESSES_ATT = "addresses";
    public static final byte[] LOCATION_TYPE = Util.encodeString("10320/loc");
    public static final byte[] LINKS_TYPE = Util.encodeString("10320/links");
    public static final byte[] HEADERS_TYPE = Util.encodeString("10320/headers");
    public static final byte[][] ALL_LOCATION_TYPES = new byte[][]{LOCATION_TYPE, LINKS_TYPE, HEADERS_TYPE};
    public static final byte[][] NAMESPACE_TYPES = new byte[][]{Common.NAMESPACE_INFO_TYPE};
    public static final byte[] URL_TYPE = Util.encodeString("URL");
    private final XParser parser = new XParser();
    private final Object lookupInitLock = new Object();
    private boolean lookupServiceInitialized = false;
    private boolean lookupServiceUnavailable;
    private Object geoIP = null;
    private final Random random = new Random();
    private final boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCountryCode(HDLServletRequest req) {
        String countryCode = req.params.getParameter(CHOOSEBY_COUNTRY);
        if (countryCode != null) {
            return countryCode;
        }
        if (this.lookupServiceUnavailable) {
            return null;
        }
        String ipAddress = req.params.getParameter("ip");
        if (ipAddress == null) {
            ipAddress = req.getRemoteAddr();
        }
        if (!this.lookupServiceInitialized) {
            Object object = this.lookupInitLock;
            synchronized (object) {
                if (!this.lookupServiceInitialized) {
                    try {
                        String dbFile = req.servlet.getInitParameter("geoip_data_file");
                        if (dbFile == null) {
                            dbFile = req.servlet.getServletContext().getRealPath("/WEB-INF/GeoIP.dat");
                        }
                        System.err.println("Creating GeoIP LookupService using " + dbFile);
                        Class<?> klass = Class.forName("com.maxmind.geoip.LookupService");
                        Constructor<?> constructor = klass.getConstructor(String.class, Integer.TYPE);
                        this.geoIP = constructor.newInstance(dbFile, 3);
                    }
                    catch (Exception e) {
                        System.err.println("Unable to initialize country lookup service: " + e);
                        e.printStackTrace(System.err);
                        this.lookupServiceUnavailable = true;
                        return null;
                    }
                    this.lookupServiceInitialized = true;
                }
            }
        }
        if (this.geoIP != null) {
            try {
                Method method = this.geoIP.getClass().getMethod("getCountry", String.class);
                Object country = method.invoke(this.geoIP, ipAddress);
                method = country.getClass().getMethod("getCode", new Class[0]);
                return (String)method.invoke(country, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Error resolving country for request: " + req);
            }
        }
        return null;
    }

    @Override
    public boolean canRedirect(HandleValue[] values) {
        return this.hasLocationOrUrlType(values);
    }

    @Override
    public boolean canShowLocations(HandleValue[] values) {
        return this.hasLocationOrUrlType(values);
    }

    private boolean hasLocationOrUrlType(HandleValue[] values) {
        if (values == null) {
            return false;
        }
        for (int i = values.length - 1; i >= 0; --i) {
            if (!values[i].hasType(LOCATION_TYPE) && !values[i].hasType(URL_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canFormat(HandleValue value) {
        return false;
    }

    @Override
    public String toHTML(String handle, HandleValue value) {
        return "<pre>" + StringUtils.cgiEscape((String)value.getDataAsString()) + "<pre>";
    }

    @Override
    public XTag doShowLocations(HDLServletRequest req, HandleValue[] values) throws Exception {
        LocContext locContext = this.determineLocContext(req, values);
        if (locContext == null) {
            return null;
        }
        if (locContext.isLegacyOnly()) {
            return this.legacyOnlyUrlTypesDoShowLocations(locContext);
        }
        String name = LOCATIONS_TAG_NAME;
        if (locContext.locXMLs != null && !locContext.locXMLs.isEmpty()) {
            name = locContext.locXMLs.get(0).getName();
        }
        XTag locs = new XTag(name);
        if (locContext.locations != null) {
            for (XTag loc : locContext.locations) {
                locs.addSubTag(this.processTemplate(loc, req.hdl));
            }
        }
        return locs;
    }

    private static final void extractLegacyURLs(HDLServletRequest req, HandleValue[] values, List<XTag> urlLocs, double defaultWeight, double defaultSubTypeWeight) {
        int i;
        boolean hasJustUrl = false;
        for (i = 0; values != null && i < values.length; ++i) {
            if (!Util.equalsCI(values[i].getType(), Common.STD_TYPE_URL)) continue;
            hasJustUrl = true;
            break;
        }
        if (!hasJustUrl) {
            defaultSubTypeWeight = defaultWeight;
        }
        for (i = 0; values != null && i < values.length; ++i) {
            if (!values[i].hasType(Common.STD_TYPE_URL)) continue;
            req.modifyExpiration(values[i]);
            double weight = defaultSubTypeWeight;
            if (hasJustUrl && Util.equalsCI(values[i].getType(), Common.STD_TYPE_URL)) {
                weight = defaultWeight;
            }
            Location.addLegacyLocationToList(values[i], weight, urlLocs);
        }
    }

    private static void addLegacyLocationToList(HandleValue val, double weight, List<XTag> urlLocs) {
        XTag urltag = new XTag(LOC_TAG_NAME);
        urltag.setAttribute(LOC_ATTRIBUTE, val.getDataAsString());
        urltag.setAttribute(WEIGHT_ATTRIBUTE, String.valueOf(weight));
        urltag.setAttribute("mode", "legacy");
        urlLocs.add(urltag);
    }

    private HDLServletRequest.HandleLocationInfo resolveNamespaceLocations(HDLServletRequest req, List<XTag> locXMLs, List<String> overridePrefixes) {
        if (overridePrefixes != null && !overridePrefixes.isEmpty()) {
            return req.resolveLocationsViaNamespace(overridePrefixes);
        }
        NamespaceInfo nsInfo = req.resRequest.getNamespace();
        List<String> nsHandles = null;
        if (nsInfo != null) {
            nsHandles = nsInfo.getLocationTemplateHandles();
        }
        if (nsHandles == null && locXMLs != null) {
            for (XTag locXML : locXMLs) {
                String nsHandle = locXML.getAttribute(NSHDL_ATTRIBUTE, null);
                if (nsHandle == null) continue;
                if (nsHandles == null) {
                    nsHandles = new ArrayList<String>();
                }
                nsHandles.add(nsHandle);
            }
        }
        if (nsHandles == null) {
            return null;
        }
        return req.resolveLocationsForMultipleHandles(nsHandles);
    }

    private void addLocsSubTagsToList(List<XTag> locXMLs, List<XTag> locations) {
        if (locXMLs == null) {
            return;
        }
        for (XTag locXML : locXMLs) {
            for (int i = 0; locXML != null && i < locXML.getSubTagCount(); ++i) {
                XTag subtag = locXML.getSubTag(i);
                if (!subtag.getName().equalsIgnoreCase(LOC_TAG_NAME) && !subtag.getName().equalsIgnoreCase(OLD_LOC_TEMPLATE_TAG_NAME)) continue;
                locations.add(subtag);
            }
        }
    }

    private LocContext determineLocContext(HDLServletRequest req, HandleValue[] values) throws Exception {
        HDLServletRequest.HandleLocationInfo locInfo;
        if (values == null) {
            return null;
        }
        ArrayList<XTag> locXMLs = new ArrayList<XTag>();
        ArrayList<XTag> linksFromLocs = new ArrayList<XTag>();
        ArrayList<XTag> links = new ArrayList<XTag>();
        ArrayList<String> headers = new ArrayList<String>();
        boolean hasLocationTypeValue = false;
        for (HandleValue value : values) {
            if (value.hasType(LOCATION_TYPE)) {
                hasLocationTypeValue = true;
                req.modifyExpiration(value);
                String locationsStr = Util.decodeString(value.getData());
                XTag locXML = this.parser.parse(new StringReader(locationsStr), false);
                if (locXML == null) continue;
                locXMLs.add(locXML);
                linksFromLocs.add(locXML);
                continue;
            }
            if (value.hasType(LINKS_TYPE)) {
                hasLocationTypeValue = true;
                req.modifyExpiration(value);
                String linksStr = Util.decodeString(value.getData());
                XTag linksXML = this.parser.parse(new StringReader(linksStr), false);
                if (linksXML == null) continue;
                links.add(linksXML);
                continue;
            }
            if (!value.hasType(HEADERS_TYPE)) continue;
            hasLocationTypeValue = true;
            req.modifyExpiration(value);
            String headersStr = Util.decodeString(value.getData());
            headers.add(headersStr);
        }
        Settings settings = new Settings();
        settings.adjust(locXMLs);
        ArrayList<XTag> locations = new ArrayList<XTag>();
        this.addLocsSubTagsToList(locXMLs, locations);
        this.processIncludes(req, locXMLs, locations, linksFromLocs, links, headers, settings, 0);
        boolean hasLocalHeaders = !links.isEmpty() || !headers.isEmpty();
        List<XTag> nsLocXMLs = null;
        ArrayList<XTag> nsLocs = new ArrayList<XTag>();
        if (!(settings.suppressNamespaceLocs != null && settings.suppressNamespaceLocs.booleanValue() || (locInfo = this.resolveNamespaceLocations(req, locXMLs, settings.overridePrefixes)) == null)) {
            nsLocXMLs = locInfo.loc;
            this.addLocsSubTagsToList(locInfo.loc, nsLocs);
            settings.adjust(locInfo.loc);
            ArrayList<XTag> nsLinksFromLocs = new ArrayList<XTag>();
            ArrayList<XTag> nsLinks = new ArrayList<XTag>();
            ArrayList<String> nsHeaders = new ArrayList<String>();
            this.processIncludes(req, nsLocXMLs, nsLocs, nsLinksFromLocs, nsLinks, nsHeaders, settings, 0);
            boolean suppress = false;
            if (settings.suppressNamespaceHeaders != null && settings.suppressNamespaceHeaders.booleanValue()) {
                suppress = true;
            }
            if (!suppress && hasLocalHeaders && settings.suppressNamespaceHeadersIfLocalHeaders != null && settings.suppressNamespaceHeadersIfLocalHeaders.booleanValue()) {
                suppress = true;
            }
            if (!suppress) {
                if (locInfo.loc != null) {
                    linksFromLocs.addAll(locInfo.loc);
                }
                if (locInfo.links != null) {
                    links.addAll(locInfo.links);
                }
                if (locInfo.headers != null) {
                    headers.addAll(locInfo.headers);
                }
                linksFromLocs.addAll(nsLinksFromLocs);
                links.addAll(nsLinks);
                headers.addAll(nsHeaders);
            }
        }
        links.addAll(linksFromLocs);
        if (hasLocationTypeValue || !nsLocs.isEmpty()) {
            if (settings.suppressLegacy == null || !settings.suppressLegacy.booleanValue()) {
                if (settings.urlWeight == null) {
                    settings.urlWeight = locXMLs.isEmpty() ? Double.valueOf(1.0) : Double.valueOf(0.0);
                }
                if (settings.urlSubtypeWeight == null) {
                    settings.urlSubtypeWeight = 0.0;
                }
                Location.extractLegacyURLs(req, values, locations, settings.urlWeight, settings.urlSubtypeWeight);
            }
            locations.addAll(nsLocs);
            return new LocContext(req, locXMLs, nsLocXMLs, links, headers, locations, null);
        }
        return new LocContext(req, locXMLs, nsLocXMLs, links, headers, null, values);
    }

    private static Boolean setFromFirstBoolAttribute(Boolean priorValue, XTag locXML, String key) {
        if (priorValue != null) {
            return priorValue;
        }
        String att = locXML.getAttribute(key);
        if (att == null) {
            return null;
        }
        return locXML.getBoolAttribute(key, false);
    }

    private static Double setFromFirstDoubleAttribute(Double priorValue, XTag locXML, String key) {
        if (priorValue != null) {
            return priorValue;
        }
        String att = locXML.getAttribute(key);
        if (att == null) {
            return null;
        }
        return locXML.getDoubleAttribute(key, 0.0);
    }

    private void processIncludes(HDLServletRequest req, List<XTag> locXMLs, List<XTag> locations, List<XTag> linksFromLocs, List<XTag> links, List<String> headers, Settings settings, int depth) {
        if (locXMLs == null) {
            return;
        }
        if (depth > 20) {
            System.err.println("Recursive 10320/loc include too deep");
            return;
        }
        HDLServletRequest.HandleLocationInfo combinedLocInfo = new HDLServletRequest.HandleLocationInfo();
        boolean found = false;
        for (XTag locXML : locXMLs) {
            List<String> include;
            List<String> includeNamespace = this.getAttributeAndSubtags(locXML, "includeNamespace");
            if (includeNamespace != null && !includeNamespace.isEmpty()) {
                HDLServletRequest.HandleLocationInfo locInfo = req.resolveLocationsViaNamespace(includeNamespace);
                boolean thisFound = HDLServletRequest.HandleLocationInfo.mergeIntoHandleLocationInfo(combinedLocInfo, locInfo);
                boolean bl = found = found || thisFound;
            }
            if ((include = this.getAttributeAndSubtags(locXML, "include")) == null || include.isEmpty()) continue;
            HDLServletRequest.HandleLocationInfo locInfo = req.resolveLocationsForMultipleHandles(include);
            boolean thisFound = HDLServletRequest.HandleLocationInfo.mergeIntoHandleLocationInfo(combinedLocInfo, locInfo);
            found = found || thisFound;
        }
        if (found) {
            this.addLocsSubTagsToList(combinedLocInfo.loc, locations);
            settings.adjust(combinedLocInfo.loc);
            this.processIncludes(req, combinedLocInfo.loc, locations, linksFromLocs, links, headers, settings, depth + 1);
            if (combinedLocInfo.loc != null) {
                linksFromLocs.addAll(combinedLocInfo.loc);
            }
            if (combinedLocInfo.links != null) {
                links.addAll(combinedLocInfo.links);
            }
            if (combinedLocInfo.headers != null) {
                headers.addAll(combinedLocInfo.headers);
            }
        }
    }

    private List<String> getAttributeAndSubtags(XTag locXML, String name) {
        String[] subTags;
        ArrayList<String> res = new ArrayList<String>();
        String att = locXML.getAttribute(name);
        if (att != null) {
            res.add(att);
        }
        if ((subTags = locXML.getStrListSubTag(name)) != null) {
            res.addAll(Arrays.asList(subTags));
        }
        return res;
    }

    @Override
    public boolean doRedirect(HDLServletRequest req, HandleValue[] values) throws Exception {
        LocContext locContext = this.determineLocContext(req, values);
        if (locContext == null) {
            return false;
        }
        if (locContext.isLegacyOnly()) {
            return this.legacyOnlyUrlTypesDoRedirect(locContext);
        }
        return this.chooseLocationFromValue(locContext);
    }

    private boolean legacyOnlyUrlTypesDoRedirect(LocContext locContext) throws IOException {
        HDLServletRequest req = locContext.req;
        HandleValue[] values = locContext.legacyValues;
        String redirectURL = null;
        for (HandleValue val : values) {
            byte[] valType;
            if (val == null || (valType = val.getType()) == null || !Util.equalsCI(valType, Common.STD_TYPE_URL) && !Util.equalsCI(valType, Url.zeroDotTypeUrl)) continue;
            req.modifyExpiration(val);
            redirectURL = val.getDataAsString();
            break;
        }
        if (redirectURL == null) {
            for (HandleValue val : values) {
                if (val == null || !val.hasType(Common.STD_TYPE_URL) && !val.hasType(Url.zeroDotTypeUrl)) continue;
                req.modifyExpiration(val);
                redirectURL = val.getDataAsString();
                break;
            }
        }
        if (redirectURL == null) {
            return false;
        }
        String urlSuffix = req.params.getParameter("urlappend");
        if (urlSuffix == null) {
            urlSuffix = "";
        }
        try {
            this.sendHttpRedirectResponse(locContext, null, redirectURL + urlSuffix);
            return true;
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                throw (IOException)e;
            }
            if (e.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
                throw e;
            }
            System.err.println("Error in legacy case of Location.doRedirect for " + req.hdl + ": " + e);
            return false;
        }
    }

    private XTag legacyOnlyUrlTypesDoShowLocations(LocContext locContext) {
        ArrayList<XTag> locations = new ArrayList<XTag>();
        HDLServletRequest req = locContext.req;
        HandleValue[] values = locContext.legacyValues;
        boolean found = false;
        for (HandleValue val : values) {
            byte[] valType;
            if (val == null || (valType = val.getType()) == null || !Util.equalsCI(valType, Common.STD_TYPE_URL) && !Util.equalsCI(valType, Url.zeroDotTypeUrl)) continue;
            double weight = found ? 0.0 : 1.0;
            found = true;
            Location.addLegacyLocationToList(val, weight, locations);
        }
        if (!found) {
            for (HandleValue val : values) {
                if (val == null || !val.hasType(Common.STD_TYPE_URL) && !val.hasType(Url.zeroDotTypeUrl)) continue;
                double weight = found ? 0.0 : 1.0;
                found = true;
                Location.addLegacyLocationToList(val, weight, locations);
            }
        }
        String name = LOCATIONS_TAG_NAME;
        XTag locs = new XTag(name);
        for (XTag loc : locations) {
            locs.addSubTag(this.processTemplate(loc, req.hdl));
        }
        return locs;
    }

    private static boolean someLocationDoesConneg(List<XTag> locations) {
        for (XTag loc : locations) {
            if (!loc.getAttribute(LOC_ATT_HTTP_ROLE, "").contains(LOC_ATT_VALUE_CONNEG)) continue;
            return true;
        }
        return false;
    }

    private static void addVaryAccept(HttpServletResponse resp) {
        resp.addHeader("Vary", ACCEPT_HEADER_STRING);
    }

    private boolean chooseLocationFromValue(LocContext locContext) throws Exception {
        String[] chooseBy;
        HDLServletRequest req = locContext.req;
        List<XTag> locations = locContext.locations;
        if (locations.isEmpty()) {
            return false;
        }
        String chooseByStr = locContext.getAttribute(null, CHOOSEBY_ATTRIBUTE, null);
        if (chooseByStr == null) {
            chooseByStr = locContext.getAttribute(null, CHOOSEBY_OLD_ATTRIBUTE, null);
        }
        String[] stringArray = chooseBy = chooseByStr == null ? DEFAULT_CHOOSEBY : chooseByStr.split(",");
        if (Location.someLocationDoesConneg(locations)) {
            Location.addVaryAccept(req.response);
        }
        for (String element : chooseBy) {
            if (locations.size() == 1) {
                return this.sendRedirect(locContext, locations.get(0));
            }
            String fieldType = element.trim().toLowerCase();
            if (fieldType.length() <= 0) continue;
            if (fieldType.equals(CHOOSEBY_COUNTRY)) {
                List<XTag> countryLocs = this.filterBasedOnCountry(locations, req);
                if (countryLocs.size() <= 0) continue;
                locations = countryLocs;
                continue;
            }
            if (fieldType.equals(CHOOSEBY_ADDRESS)) {
                List<XTag> newLocs;
                String ipAddress = req.getRemoteAddr();
                if (ipAddress == null || (newLocs = this.filterBasedOnAddress(locations, ipAddress)).isEmpty()) continue;
                locations = newLocs;
                continue;
            }
            if (fieldType.equals(CHOOSEBY_LINKPARAM)) {
                String[] linkParams = req.params.getParameterValues(CHOOSEBY_LINKPARAM);
                if (linkParams == null || linkParams.length <= 0) continue;
                for (String linkParam : linkParams) {
                    List<XTag> newlocs;
                    if (linkParam == null || (newlocs = this.filterBasedOnLinkParam(locations, linkParam)).size() <= 0) continue;
                    locations = newlocs;
                }
                continue;
            }
            if (fieldType.equals(CHOOSEBY_SCORE)) {
                List<XTag> newLocs = this.filterBasedOnScore(locations);
                locations = newLocs;
                continue;
            }
            if (!fieldType.equals(CHOOSEBY_WEIGHTED)) continue;
            return this.sendWeightedRedirect(locContext, locations);
        }
        return this.sendWeightedRedirect(locContext, locations);
    }

    private List<XTag> filterBasedOnCountry(List<XTag> locations, HDLServletRequest req) {
        String myCountry = null;
        ArrayList<XTag> countryLocs = new ArrayList<XTag>();
        for (int v = 0; v < locations.size(); ++v) {
            XTag loctag = locations.get(v);
            String locCountry = loctag.getStrAttribute(CHOOSEBY_COUNTRY, null);
            if (locCountry != null && myCountry == null && (myCountry = this.getCountryCode(req)) == null) {
                System.err.println("Couldn't determine country from address: " + req.getRemoteAddr());
                break;
            }
            if (locCountry != null && myCountry != null && myCountry.equalsIgnoreCase(locCountry.trim())) {
                countryLocs.add(loctag);
                continue;
            }
            if (locCountry == null) continue;
        }
        return countryLocs;
    }

    private List<XTag> filterBasedOnAddress(List<XTag> locations, String ipAddress) throws UnknownHostException {
        BigInteger target = null;
        ArrayList<XTag> newLocs = new ArrayList<XTag>();
        for (XTag locTag : locations) {
            String[] addressesList;
            String addresses = locTag.getStrAttribute(ADDRESSES_ATT, null);
            if (addresses == null) continue;
            if (target == null) {
                target = CIDRUtils.asBigInteger(ipAddress);
            }
            for (String address : addressesList = addresses.split(",")) {
                CIDRUtils range = new CIDRUtils(address = address.trim());
                if (!range.isInRange(target)) continue;
                newLocs.add(locTag);
            }
        }
        return newLocs;
    }

    private List<XTag> filterBasedOnLinkParam(List<XTag> locations, String linkParam) {
        int colIdx = linkParam.indexOf(58);
        String attName = colIdx < 0 ? linkParam.trim() : linkParam.substring(0, colIdx).trim();
        String attVal = colIdx < 0 ? null : linkParam.substring(colIdx + 1);
        ArrayList<XTag> newlocs = new ArrayList<XTag>();
        for (int v = 0; v < locations.size(); ++v) {
            XTag loctag = locations.get(v);
            String att = loctag.getAttribute(attName, null);
            if (att == null || attVal != null && !attVal.equals(att)) continue;
            newlocs.add(loctag);
        }
        return newlocs;
    }

    private List<XTag> filterBasedOnScore(List<XTag> locations) {
        double maxScore = 0.0;
        ArrayList<XTag> newLocs = new ArrayList<XTag>();
        for (XTag locTag : locations) {
            double score = locTag.getDoubleAttribute(CHOOSEBY_SCORE, 0.0);
            if (score > maxScore) {
                maxScore = score;
                newLocs.clear();
            }
            if (score != maxScore) continue;
            newLocs.add(locTag);
        }
        return newLocs;
    }

    private boolean sendWeightedRedirect(LocContext locContext, List<XTag> locations) throws IOException {
        if (locations.size() <= 0) {
            return false;
        }
        double totalWeight = 0.0;
        for (int i = locations.size() - 1; i >= 0; --i) {
            double weight = locations.get(i).getDoubleAttribute(WEIGHT_ATTRIBUTE, 1.0);
            totalWeight += Math.max(0.0, weight);
        }
        int randIdx = 0;
        if (totalWeight > 0.0) {
            double randVal = this.random.nextDouble() * totalWeight;
            totalWeight = 0.0;
            XTag loc = null;
            for (int i = locations.size() - 1; i >= 0; --i) {
                loc = locations.get(i);
                if (!((totalWeight += Math.max(0.0, loc.getDoubleAttribute(WEIGHT_ATTRIBUTE, 1.0))) >= randVal)) continue;
                return this.sendRedirect(locContext, loc);
            }
            if (loc != null) {
                return this.sendRedirect(locContext, loc);
            }
            return false;
        }
        randIdx = (int)Math.round(Math.abs(this.random.nextDouble()) * (double)locations.size());
        randIdx = Math.max(0, Math.min(locations.size() - 1, randIdx));
        return this.sendRedirect(locContext, locations.get(randIdx));
    }

    private XTag processTemplate(XTag locInfo, String handle) {
        String locTemplate;
        if (locInfo.getStrAttribute(LOC_ATTRIBUTE, null) == null && (locTemplate = locInfo.getStrAttribute(LOC_TEMPLATE_ATTRIBUTE, null)) != null) {
            String loc = this.processTemplate(locTemplate, handle);
            locInfo = locInfo.shallowCloneTag();
            locInfo.setAttribute(LOC_ATTRIBUTE, loc);
            return locInfo;
        }
        return locInfo;
    }

    private String processTemplate(String locTemplate, String handle) {
        String res = locTemplate.replace(HDL_TEMPLATE_STRING, StringUtils.encodeURLComponent((String)handle));
        res = res.replace(HDL_PATH_TEMPLATE_STRING, StringUtils.encodeURLPath((String)handle));
        return res;
    }

    private boolean sendRedirect(LocContext locContext, XTag locInfo) throws IOException {
        HDLServletRequest req = locContext.req;
        try {
            locInfo = this.processTemplate(locInfo, req.hdl);
            String url = locInfo.getStrAttribute(LOC_ATTRIBUTE, null);
            if (url == null) {
                System.err.println("Error: no URL in location: " + locInfo);
                return false;
            }
            String urlSuffix = req.params.getParameter("urlappend");
            if (urlSuffix != null) {
                url = url + urlSuffix;
            }
            this.sendHttpRedirectResponse(locContext, locInfo, url);
            return true;
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                throw (IOException)e;
            }
            if (e.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
                throw e;
            }
            System.err.println("Error in Location.sendRedirect for " + req + ": " + e);
            return false;
        }
    }

    private void sendHttpRedirectResponse(LocContext locContext, XTag locInfo, String url) throws UnsupportedEncodingException, IOException {
        HDLServletRequest req = locContext.req;
        String redirectType = locContext.getAttribute(locInfo, REDIRECT_TYPE_ATT, null);
        req.sendHTTPRedirect(HDLServletRequest.ResponseType.typeForString(redirectType), url);
        this.writeHttpHeaders(req.response, locContext.headers, req.hdl);
        this.writeLinks(req.response, locContext.links, req.hdl);
        req.response.setContentType("text/html; charset=utf-8");
        String escapedURL = StringUtils.cgiEscape((String)url);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)req.response.getOutputStream(), "UTF-8");
        out.write("<html><head><title>Handle Redirect</title>");
        this.writeHtmlHeaders(out, locContext.headers, req.hdl);
        out.write("</head>\n<body><a href=\"" + escapedURL + "\">");
        out.write(escapedURL + "</a></body></html>");
        out.close();
    }

    private void writeHttpHeaders(HttpServletResponse response, List<String> headers, String handle) {
        if (headers == null) {
            return;
        }
        for (String headerStrings : headers) {
            for (String header : headerStrings.split("\n")) {
                int colon;
                if ((header = header.trim()).isEmpty() || header.startsWith("<") || (colon = header.indexOf(58)) < 0) continue;
                String name = header.substring(0, colon).trim();
                String value = header.substring(colon + 1).trim();
                value = this.processTemplate(value, handle);
                response.addHeader(name, value);
            }
        }
    }

    private void writeLinks(HttpServletResponse response, List<XTag> links, String handle) {
        if (links == null) {
            return;
        }
        for (XTag linksTag : links) {
            HashMap<String, String> anchors = new HashMap<String, String>();
            ArrayList<XTag> locSubtags = new ArrayList<XTag>();
            for (int i = 0; i < linksTag.getSubTagCount(); ++i) {
                String href;
                String rel;
                XTag subtag = linksTag.getSubTag(i);
                if (!subtag.getName().equalsIgnoreCase(LOC_TAG_NAME) && !subtag.getName().equalsIgnoreCase(OLD_LOC_TEMPLATE_TAG_NAME) || (rel = subtag.getAttribute("rel")) == null || (href = (subtag = this.processTemplate(subtag, handle)).getAttribute(LOC_ATTRIBUTE)) == null) continue;
                String id = subtag.getAttribute("id");
                if (id != null) {
                    anchors.put(id, href);
                }
                locSubtags.add(subtag);
            }
            for (XTag subtag : locSubtags) {
                String anchorId;
                String anchor = subtag.getAttribute("anchor");
                if (anchor != null || (anchorId = subtag.getAttribute("anchor-id")) == null || (anchor = (String)anchors.get(anchorId)) == null) continue;
                subtag.setAttribute("anchor", anchor);
            }
            for (XTag subtag : locSubtags) {
                String value = this.getLinkValue(subtag);
                response.addHeader("Link", value);
            }
        }
    }

    private String getLinkValue(XTag locTag) {
        String href = locTag.getAttribute(LOC_ATTRIBUTE);
        String rel = locTag.getAttribute("rel");
        String anchor = locTag.getAttribute("anchor");
        String mediaType = locTag.getAttribute("media-type");
        String targetType = locTag.getAttribute("target-type");
        String title = locTag.getAttribute("title");
        String media = locTag.getAttribute("media");
        String hreflang = locTag.getAttribute("hreflang");
        String titlelang = locTag.getAttribute("titlelang");
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(StringUtils.encodeURL((String)href));
        sb.append(">");
        if (anchor != null) {
            sb.append("; anchor=\"");
            sb.append(StringUtils.encodeURL((String)anchor));
            sb.append("\"");
        }
        if (rel != null) {
            sb.append("; rel=\"");
            sb.append(rel);
            sb.append("\"");
        }
        if (mediaType != null) {
            sb.append("; type=\"");
            sb.append(mediaType);
            sb.append("\"");
        }
        if (targetType != null) {
            sb.append("; target-type=\"");
            sb.append(targetType);
            sb.append("\"");
        }
        if (media != null) {
            sb.append("; media=\"");
            sb.append(media);
            sb.append("\"");
        }
        if (hreflang != null) {
            sb.append("; hreflang=\"");
            sb.append(hreflang);
            sb.append("\"");
        }
        if (title != null) {
            if (titlelang == null && Location.isPrintableAscii(title)) {
                sb.append("; title=\"");
                sb.append(title.replace("\\", "\\\\").replace("\"", "\\\""));
                sb.append("\"");
            } else {
                sb.append("; title*=UTF-8'");
                if (titlelang != null) {
                    sb.append(titlelang);
                }
                sb.append("'");
                sb.append(StringUtils.encodeURLComponent((String)title));
            }
        }
        return sb.toString();
    }

    private static boolean isPrintableAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' && ch < '\u007f') continue;
            return false;
        }
        return true;
    }

    private void writeHtmlHeaders(Writer out, List<String> headers, String handle) throws IOException {
        if (headers == null) {
            return;
        }
        boolean first = true;
        for (String headerStrings : headers) {
            for (String header : headerStrings.split("\n")) {
                if (!header.trim().startsWith("<")) continue;
                if (first) {
                    out.write("\n");
                    first = false;
                }
                out.write(this.processTemplate(header, handle));
                out.write("\n");
            }
        }
    }

    private static class LocContext {
        final HDLServletRequest req;
        final List<XTag> locXMLs;
        final List<XTag> links;
        final List<String> headers;
        final List<XTag> nsLocXMLs;
        final List<XTag> locations;
        final HandleValue[] legacyValues;

        LocContext(HDLServletRequest req, List<XTag> locXMLs, List<XTag> nsLocXMLs, List<XTag> links, List<String> headers, List<XTag> locations, HandleValue[] legacyValues) {
            this.locXMLs = locXMLs;
            this.nsLocXMLs = nsLocXMLs;
            this.req = req;
            this.links = links;
            this.headers = headers;
            this.locations = locations;
            this.legacyValues = legacyValues;
        }

        public boolean isLegacyOnly() {
            return this.legacyValues != null;
        }

        public String getAttribute(XTag loc, String attributeName, String defaultValue) {
            String val = null;
            if (loc != null && (val = loc.getAttribute(attributeName)) != null) {
                return val;
            }
            if (this.locXMLs != null) {
                for (XTag parentInfoTag : this.locXMLs) {
                    val = parentInfoTag.getAttribute(attributeName);
                    if (val == null) continue;
                    return val;
                }
            }
            if (this.nsLocXMLs != null) {
                for (XTag parentLocs : this.nsLocXMLs) {
                    val = parentLocs.getAttribute(attributeName);
                    if (val == null) continue;
                    return val;
                }
            }
            return defaultValue;
        }
    }

    private static class Settings {
        Boolean suppressLegacy = null;
        Boolean suppressNamespaceLocs = null;
        Double urlWeight = null;
        Double urlSubtypeWeight = null;
        Boolean suppressNamespaceHeaders = null;
        Boolean suppressNamespaceHeadersIfLocalHeaders = null;
        List<String> overridePrefixes = new ArrayList<String>();

        private Settings() {
        }

        void adjust(XTag locXML) {
            this.suppressNamespaceLocs = Location.setFromFirstBoolAttribute(this.suppressNamespaceLocs, locXML, Location.SUPPRESS_NAMESPACE_LOCS);
            this.suppressLegacy = Location.setFromFirstBoolAttribute(this.suppressLegacy, locXML, Location.SUPPRESS_LEGACY);
            this.suppressNamespaceHeaders = Location.setFromFirstBoolAttribute(this.suppressNamespaceHeaders, locXML, "suppressNsHeaders");
            this.suppressNamespaceHeadersIfLocalHeaders = Location.setFromFirstBoolAttribute(this.suppressNamespaceHeadersIfLocalHeaders, locXML, "suppressNsHeadersIfLocalHeaders");
            this.urlWeight = Location.setFromFirstDoubleAttribute(this.urlWeight, locXML, "urlWeight");
            this.urlSubtypeWeight = Location.setFromFirstDoubleAttribute(this.urlSubtypeWeight, locXML, "urlSubtypeWeight");
            String overridePrefix = locXML.getAttribute("overridePrefix");
            if (overridePrefix != null) {
                this.overridePrefixes.add(overridePrefix);
            }
        }

        void adjust(List<XTag> locXMLs) {
            if (locXMLs == null) {
                return;
            }
            for (XTag locXML : locXMLs) {
                this.adjust(locXML);
            }
        }
    }
}

