/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.handle.util.FileSystemReadOnlyChecker;

public class RotatingAccessLog
implements Runnable {
    private static final int ACCESS_LOG_BUFFER_SIZE = 100000;
    private static final int EXTRA_LOG_BUFFER_SIZE = 100000;
    public static final int ERRLOG_LEVEL_EVERYTHING = 0;
    public static final int ERRLOG_LEVEL_INFO = 25;
    public static final int ERRLOG_LEVEL_NORMAL = 50;
    public static final int ERRLOG_LEVEL_REALBAD = 75;
    public static final int ERRLOG_LEVEL_FATAL = 100;
    private int errorLoggingLevel = 25;
    private File logDirectory;
    private Path reloadFile;
    private Writer accessWriter;
    private Writer errorWriter;
    private PrintStream errorPrintStream;
    private Writer extraWriter;
    private DateTimeFormatter errorLogDateFormat;
    private boolean continuing = true;
    private final boolean loggingAccesses = true;
    private boolean loggingExtras = false;
    private final String ERROR_LOG_LOCK = "error_log_lock";
    private final String ACCESS_LOG_LOCK = "access_log_lock";
    private Thread flusherThread;
    private Thread rotaterThread;
    private final LogRotater logRotater;
    private ScheduledExecutorService reloadExecServ;
    private final AtomicInteger requestsCurrentMinute = new AtomicInteger();
    private final AtomicInteger requestsPastMinute = new AtomicInteger();
    private final AtomicInteger peakRequestsPerMinute = new AtomicInteger();
    private ScheduledExecutorService requestCountingExecServ;
    private static final Object loggerLock = new Object();
    private static volatile RotatingAccessLog logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotatingAccessLog getLogger(File logDir, RotationRate rotationRate) throws Exception {
        if (logger != null) {
            return logger;
        }
        Object object = loggerLock;
        synchronized (object) {
            if (logger == null) {
                logger = new RotatingAccessLog(logDir, rotationRate);
            }
        }
        return logger;
    }

    RotatingAccessLog(File logDir, RotationRate rotationRate) throws Exception {
        if (logDir == null) {
            throw new NullPointerException("Log directory cannot be null");
        }
        if (logDir.exists()) {
            if (!logDir.isDirectory()) {
                throw new Exception("\"" + logDir.getAbsolutePath() + "\" is not a directory.");
            }
        } else {
            boolean created = logDir.mkdirs();
            if (!created || FileSystemReadOnlyChecker.isReadOnly(logDir)) {
                throw new Exception("Log directory is not writable.");
            }
        }
        this.logDirectory = logDir;
        this.reloadFile = logDir.toPath().resolve("log_file_reload_required");
        this.errorLogDateFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss z").withZone(ZoneId.systemDefault());
        this.loggingExtras = true;
        this.requestCountingExecServ = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "RotatingAccessLog-counter");
            t.setDaemon(true);
            return t;
        });
        this.requestCountingExecServ.scheduleAtFixedRate(this::rotateRequestsPerMinute, 1L, 1L, TimeUnit.MINUTES);
        this.reloadExecServ = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "RotatingAccessLog-reloadWatcher");
            t.setDaemon(true);
            return t;
        });
        this.reloadExecServ.scheduleAtFixedRate(this::reloadLogFileIfRequested, 1L, 1L, TimeUnit.MINUTES);
        this.logRotater = new LogRotater(rotationRate);
        this.logRotater.setLogFiles(System.currentTimeMillis());
        if (rotationRate != RotationRate.ROTATE_NEVER) {
            this.rotaterThread = new Thread(this.logRotater);
            this.rotaterThread.setPriority(1);
            this.rotaterThread.setDaemon(true);
            this.rotaterThread.start();
        }
        this.logError(25, "Started new run.");
        this.flusherThread = new Thread(this);
        this.flusherThread.setDaemon(true);
        this.flusherThread.start();
    }

    public void setLoggingExtras(boolean logExtras) {
        this.loggingExtras = logExtras;
    }

    public void setErrorLogLevel(int newLogLevel) {
        this.errorLoggingLevel = newLogLevel;
    }

    private static String removeNewlines(String s) {
        return s.replace("\n", "\\n").replace("\r", "\\r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAccessAndExtra(String accessLogStr, String extraLogStr) {
        this.requestsCurrentMinute.incrementAndGet();
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter == null) {
                System.err.println(accessLogStr);
            } else {
                try {
                    this.accessWriter.write(RotatingAccessLog.removeNewlines(accessLogStr));
                    this.accessWriter.write(10);
                }
                catch (Exception e) {
                    System.err.println("Error writing to access log: (" + e + "): " + accessLogStr);
                }
            }
            if (this.extraWriter == null) {
                if (extraLogStr != null) {
                    System.err.println(extraLogStr);
                }
            } else {
                try {
                    if (extraLogStr != null) {
                        this.extraWriter.write(RotatingAccessLog.removeNewlines(extraLogStr));
                    }
                    this.extraWriter.write(10);
                }
                catch (Exception e) {
                    System.err.println("Error writing to extra log: (" + e + "): " + extraLogStr);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logError(int level, String logString) {
        if (level < this.errorLoggingLevel || logString == null) {
            return;
        }
        String msg = "\"" + this.errorLogDateFormat.format(Instant.now()) + "\" " + level + ' ' + logString;
        if (level == 100 || this.errorWriter == null) {
            System.err.println(msg);
        }
        if (this.errorWriter == null) return;
        String string = "error_log_lock";
        synchronized ("error_log_lock") {
            try {
                this.errorWriter.write(msg + '\n');
                this.errorWriter.flush();
            }
            catch (Exception e) {
                System.err.println("Error (" + e + ") writing \"" + logString + "\" to error log.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccessLogFile(File newAccessLogFile) throws IOException {
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter != null) {
                this.accessWriter.flush();
                this.accessWriter.close();
                this.accessWriter = null;
            }
            this.accessWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newAccessLogFile.getAbsolutePath(), true), "UTF-8"), 100000);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtraLogFile(File newExtraLogFile) throws IOException {
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.extraWriter != null) {
                this.extraWriter.flush();
                this.extraWriter.close();
                this.extraWriter = null;
            }
            if (this.loggingExtras) {
                this.extraWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newExtraLogFile.getAbsolutePath(), true), "UTF-8"), 100000);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorLogFile(File newErrorLogFile) throws IOException {
        String string = "error_log_lock";
        synchronized ("error_log_lock") {
            Writer oldWriter = null;
            PrintStream oldPrintStream = null;
            try {
                oldPrintStream = this.errorPrintStream;
                oldWriter = this.errorWriter;
                this.errorWriter = null;
                FileOutputStream errf = new FileOutputStream(newErrorLogFile.getAbsolutePath(), true);
                this.errorPrintStream = new PrintStream(errf);
                System.setErr(this.errorPrintStream);
                this.errorWriter = new OutputStreamWriter((OutputStream)errf, "UTF-8");
            }
            finally {
                try {
                    if (oldPrintStream != null) {
                        oldPrintStream.flush();
                    }
                    if (oldWriter != null) {
                        oldWriter.close();
                    }
                    if (oldPrintStream != null) {
                        oldPrintStream.close();
                    }
                }
                catch (Throwable t) {
                    System.err.println("Error setting error log file: " + t);
                    t.printStackTrace(System.err);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void reloadLogFileIfRequested() {
        try {
            if (Files.exists(this.reloadFile, new LinkOption[0])) {
                System.err.println("Log rotate watch file found. Reloading log files.");
                long now = System.currentTimeMillis();
                this.logRotater.setLogFiles(now);
                Files.delete(this.reloadFile);
            }
        }
        catch (Exception e) {
            System.err.println("Error reloading log files: " + e);
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (this.continuing) {
            try {
                String string = "access_log_lock";
                // MONITORENTER : "access_log_lock"
                if (this.accessWriter != null) {
                    this.accessWriter.flush();
                }
                if (this.extraWriter != null) {
                    this.extraWriter.flush();
                }
                // MONITOREXIT : string
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        String string;
        this.continuing = false;
        if (this.flusherThread != null) {
            string = "access_log_lock";
            // MONITORENTER : "access_log_lock"
            try {
                this.flusherThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rotaterThread != null) {
            string = "access_log_lock";
            // MONITORENTER : "access_log_lock"
            try {
                this.rotaterThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = "error_log_lock";
        // MONITORENTER : "error_log_lock"
        if (this.errorWriter != null) {
            try {
                this.errorWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        // MONITOREXIT : string
        string = "access_log_lock";
        // MONITORENTER : "access_log_lock"
        if (this.accessWriter != null) {
            try {
                this.accessWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.extraWriter != null) {
            try {
                this.extraWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        // MONITOREXIT : string
        if (this.requestCountingExecServ != null) {
            this.requestCountingExecServ.shutdown();
            try {
                this.requestCountingExecServ.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.reloadExecServ == null) return;
        this.reloadExecServ.shutdown();
        try {
            this.reloadExecServ.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void rotateRequestsPerMinute() {
        int newRequestsPastMinute = this.requestsCurrentMinute.getAndSet(0);
        this.requestsPastMinute.set(newRequestsPastMinute);
        int pastPeak = this.peakRequestsPerMinute.get();
        if (newRequestsPastMinute > pastPeak) {
            this.peakRequestsPerMinute.set(newRequestsPastMinute);
        }
    }

    public AtomicInteger getRequestsPastMinute() {
        return this.requestsPastMinute;
    }

    public AtomicInteger getPeakRequestsPerMinute() {
        return this.peakRequestsPerMinute;
    }

    public static enum RotationRate {
        ROTATE_MONTHLY(ChronoUnit.MONTHS, "-yyyyMM"),
        ROTATE_DAILY(ChronoUnit.DAYS, "-yyyyMMdd"),
        ROTATE_HOURLY(ChronoUnit.HOURS, "-yyyyMMddHH"),
        ROTATE_NEVER(ChronoUnit.FOREVER, "");

        private final ChronoUnit chronoUnit;
        private final String logFileSuffixPattern;

        private RotationRate(ChronoUnit chronoUnit, String logFileSuffixPattern) {
            this.chronoUnit = chronoUnit;
            this.logFileSuffixPattern = logFileSuffixPattern;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public String getLogFileSuffixPattern() {
            return this.logFileSuffixPattern;
        }
    }

    class LogRotater
    implements Runnable {
        private final ChronoUnit chronoUnit;
        private final DateTimeFormatter dateTimeFormatter;

        LogRotater(RotationRate rotationRate) {
            this.chronoUnit = rotationRate.getChronoUnit();
            String suffixPattern = rotationRate.getLogFileSuffixPattern();
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(suffixPattern).withZone(ZoneId.systemDefault());
        }

        long getNextRotationTimeInMilli(long currentTime) {
            if (this.chronoUnit == ChronoUnit.FOREVER) {
                return Long.MAX_VALUE;
            }
            Instant instant = Instant.ofEpochMilli(currentTime);
            if (this.chronoUnit.isDateBased()) {
                ZonedDateTime date = instant.atZone(ZoneId.systemDefault());
                date = date.truncatedTo(ChronoUnit.DAYS);
                if (this.chronoUnit == ChronoUnit.MONTHS) {
                    date = date.with(ChronoField.DAY_OF_MONTH, 1L);
                }
                date = date.plus(1L, this.chronoUnit);
                return Instant.from(date).toEpochMilli();
            }
            return instant.truncatedTo(this.chronoUnit).plus(1L, this.chronoUnit).toEpochMilli();
        }

        private String getLogFileSuffix(long currentTime) {
            Instant instant = Instant.ofEpochMilli(currentTime);
            return this.dateTimeFormatter.format(instant);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setLogFiles(long currentTimeInMillis) throws IOException {
            String logFileSuffix = this.getLogFileSuffix(currentTimeInMillis);
            String string = "error_log_lock";
            synchronized ("error_log_lock") {
                RotatingAccessLog.this.setErrorLogFile(new File(RotatingAccessLog.this.logDirectory, "error.log" + logFileSuffix));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                string = "access_log_lock";
                synchronized ("access_log_lock") {
                    RotatingAccessLog.this.setAccessLogFile(new File(RotatingAccessLog.this.logDirectory, "access.log" + logFileSuffix));
                    RotatingAccessLog.this.setExtraLogFile(new File(RotatingAccessLog.this.logDirectory, "extra.log" + logFileSuffix));
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
            }
        }

        @Override
        public void run() {
            while (RotatingAccessLog.this.continuing) {
                try {
                    long nextRotationTime = this.getNextRotationTimeInMilli(System.currentTimeMillis());
                    while (RotatingAccessLog.this.continuing && nextRotationTime > System.currentTimeMillis()) {
                        try {
                            Thread.sleep(Math.max(60000L, nextRotationTime - System.currentTimeMillis()));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable t) {
                            System.err.println("Error sleeping in log rotation thread: " + t);
                            t.printStackTrace(System.err);
                        }
                    }
                    this.setLogFiles(System.currentTimeMillis());
                }
                catch (Exception e) {
                    System.err.println("Error in log rotation thread " + e);
                    e.printStackTrace(System.err);
                    if (!RotatingAccessLog.this.continuing) continue;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

