/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.StringReader;
import java.net.IDN;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.cnri.util.StringUtils;
import net.handle.apps.servlet_proxy.HDLProxy;
import net.handle.apps.servlet_proxy.HttpParams;
import net.handle.apps.servlet_proxy.handlers.Location;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;
import net.handle.util.LRUCacheTable;

public class HDLServletRequest {
    private static LRUCacheTable<String, HandleLocationInfo> locationsCache = new LRUCacheTable(4096);
    private static HashMap<String, String> SPECIFIC_BROWSER_CONTENT_TYPES = new HashMap();
    private static Comparator<AcceptEntry> acceptEntrySorter;
    public HDLProxy servlet;
    public HttpServletRequest req;
    private final InetAddress remoteInetAddress;
    private final String remoteAddr;
    public HttpServletResponse response;
    public String hdl = null;
    public HttpParams params = new HttpParams();
    public AuthenticationInfo authenticationInfo;
    private final Map<String, HandleLocationInfo> thisRequestLocationsCache = new HashMap<String, HandleLocationInfo>();
    public boolean api = false;
    public boolean oldApi = false;
    public ResolutionRequest resRequest = null;
    public AbstractResponse resResponse = null;
    public long resolutionTime;
    public HandleException exception;
    private long expiration = Long.MAX_VALUE;
    private RequestProcessor resolver = null;
    private final long intime = System.currentTimeMillis();
    private static XParser xmlParser;
    private static final String hdlHandleNetRegex = "hdl\\.handle\\.net";
    private static final String doiOrgRegex = "(?:dx\\.)?doi\\.org";
    private static final Pattern proxyHttpUriPattern;

    public HDLServletRequest(HDLProxy proxy, HttpServletRequest req, HttpServletResponse response, RequestProcessor resolver) {
        List<String> locattParams;
        String contextPath;
        int indexOfContextPath;
        String pathInfo;
        int n;
        this.resolver = resolver;
        this.servlet = proxy;
        this.req = req;
        this.remoteInetAddress = this.servlet.getRemoteInetAddress(req);
        this.remoteAddr = this.servlet.getRemoteAddr(req);
        this.response = response;
        String requestURI = req.getRequestURI();
        if ((req.getQueryString() == null || req.getQueryString().length() == 0) && (n = requestURI.indexOf(35)) >= 0) {
            requestURI = requestURI.substring(0, n);
        }
        this.hdl = pathInfo = (indexOfContextPath = (requestURI = StringUtils.decodeURLIgnorePlus((String)requestURI)).indexOf(contextPath = StringUtils.decodeURLIgnorePlus((String)req.getContextPath()))) < 0 ? requestURI : requestURI.substring(indexOfContextPath + contextPath.length());
        if (this.hdl == null) {
            this.hdl = "";
        }
        while (this.hdl.startsWith("/")) {
            this.hdl = this.hdl.substring(1);
        }
        this.hdl = HDLServletRequest.trimBetter(this.hdl);
        if (req.getMethod().equalsIgnoreCase("POST")) {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.params.addParameters(key, req.getParameterValues(key));
            }
            String hdlStr = req.getParameter("hdl");
            if (hdlStr != null) {
                this.hdl = HDLServletRequest.trimBetter(hdlStr);
            }
        } else if (req.getMethod().equalsIgnoreCase("GET") || req.getMethod().equalsIgnoreCase("HEAD")) {
            this.parseGetParams(req.getRequestURI(), req.getQueryString());
        }
        boolean setMetadataParam = false;
        String actionParam = this.params.getParameter("action");
        if (actionParam != null && actionParam.equalsIgnoreCase("metadata")) {
            this.params.replaceParameterValue("action", "redirect");
            this.params.addParameter("locatt", "role:metadata");
            setMetadataParam = true;
        }
        if ((locattParams = proxy.locattShortcutParameters.get(req.getServerName().toLowerCase())) == null) {
            locattParams = proxy.locattShortcutParameters.get("default");
        }
        for (String locattParam : locattParams) {
            String value = this.params.getParameter(locattParam);
            if (value == null) continue;
            this.params.addParameter("locatt", locattParam + ":" + value);
        }
        this.processAcceptHeader(setMetadataParam);
        this.processAcceptLanguageHeader();
    }

    static String trimBetter(String s) {
        int start;
        int end = s.length();
        for (start = 0; start < end && HDLServletRequest.isTrimmable(s.charAt(start)); ++start) {
        }
        while (start < end && HDLServletRequest.isTrimmable(s.charAt(end - 1))) {
            --end;
        }
        if (start == 0 && end == s.length()) {
            return s;
        }
        if (start == end) {
            return "";
        }
        return s.substring(start, end);
    }

    static boolean isTrimmable(char ch) {
        if (ch <= ' ') {
            return true;
        }
        if (ch < '\u007f') {
            return false;
        }
        if (ch <= '\u00a0') {
            return true;
        }
        if (ch == '\u1680' || ch == '\u180e') {
            return true;
        }
        if (ch < '\u2000') {
            return false;
        }
        if (ch <= '\u200d') {
            return true;
        }
        return ch == '\u2028' || ch == '\u2029' || ch == '\u202f' || ch == '\u205f' || ch == '\u2060' || ch == '\u3000' || ch == '\ufeff' || ch == '\ufffe' || ch == '\uffff';
    }

    private void processAcceptHeader(boolean setMetadataParam) {
        List<AcceptEntry> accepts = this.parseAcceptHeader("accept");
        if (this.acceptsIsJustStarStar(accepts)) {
            String userAgent = this.req.getHeader("User-Agent");
            if (userAgent == null) {
                if (!setMetadataParam) {
                    this.params.addParameter("locatt", "http_role:no_conneg");
                }
                return;
            }
            if ((userAgent = userAgent.trim().toLowerCase()).startsWith("mozilla/") || userAgent.startsWith("opera/")) {
                if (!setMetadataParam) {
                    this.params.addParameter("locatt", "http_role:browser");
                }
                this.params.addParameter("locatt", "ctype:text/html");
                this.params.addParameter("locatt", "media-type:text/html");
                return;
            }
            if (!setMetadataParam) {
                this.params.addParameter("locatt", "http_role:no_conneg");
            }
            return;
        }
        float htmlScore = 0.0f;
        float maxScore = 0.0f;
        for (AcceptEntry acceptEntry : accepts) {
            float thisScore = acceptEntry.quality;
            if (thisScore > maxScore) {
                maxScore = thisScore;
            }
            if (!(thisScore > htmlScore) || !AcceptEntry.acceptsBrowserContent(acceptEntry.value)) continue;
            htmlScore = thisScore;
        }
        if (htmlScore < maxScore) {
            Collections.sort(accepts, acceptEntrySorter);
            for (AcceptEntry acceptEntry : accepts) {
                if (AcceptEntry.hasWildcard(acceptEntry.value)) break;
                this.params.addParameter("locatt", "ctype:" + acceptEntry.value);
                this.params.addParameter("locatt", "media-type:" + acceptEntry.value);
            }
            if (!setMetadataParam) {
                this.params.addParameter("locatt", "http_role:conneg");
            }
        } else {
            if (!setMetadataParam) {
                this.params.addParameter("locatt", "http_role:browser");
            }
            if (this.textHtmlAcceptable(accepts)) {
                this.params.addParameter("locatt", "ctype:text/html");
                this.params.addParameter("locatt", "media-type:text/html");
            }
        }
    }

    private boolean textHtmlAcceptable(List<AcceptEntry> accepts) {
        for (AcceptEntry acceptEntry : accepts) {
            if ("text/html".equals(acceptEntry.value)) {
                return true;
            }
            if ("text/*".equals(acceptEntry.value)) {
                return true;
            }
            if (!"*/*".equals(acceptEntry.value)) continue;
            return true;
        }
        return false;
    }

    private boolean acceptsIsJustStarStar(List<AcceptEntry> accepts) {
        for (AcceptEntry acceptEntry : accepts) {
            if ("*/*".equals(acceptEntry.value)) continue;
            return false;
        }
        return true;
    }

    private void processAcceptLanguageHeader() {
        List<AcceptEntry> accepts = this.parseAcceptHeader("accept-language");
        Collections.sort(accepts, acceptEntrySorter);
        for (AcceptEntry acceptEntry : accepts) {
            this.params.addParameter("locatt", "language:" + acceptEntry.value);
        }
    }

    private List<AcceptEntry> parseAcceptHeader(String header) {
        ArrayList<AcceptEntry> accepts = new ArrayList<AcceptEntry>();
        List<String> acceptsHeaders = this.getRequestHeader(header);
        for (String field : acceptsHeaders) {
            String[] entries;
            if (field == null) continue;
            for (String headerValue : entries = field.split(",")) {
                AcceptEntry acceptEntry = new AcceptEntry(headerValue.split(";"));
                accepts.add(acceptEntry);
            }
        }
        return accepts;
    }

    private void parseGetParams(String URI2, String query) {
        if (query == null || query.length() == 0) {
            int n = URI2.indexOf(35);
            if (n >= 0) {
                this.params.addParameter("urlappend", StringUtils.decodeURLIgnorePlus((String)URI2.substring(n)));
            }
        } else {
            int n = query.indexOf(35);
            if (n >= 0) {
                this.params.addParameter("urlappend", StringUtils.decodeURLIgnorePlus((String)query.substring(n)));
                query = query.substring(0, n);
            }
            StringTokenizer st = new StringTokenizer(query, "&;");
            while (st.hasMoreTokens()) {
                String val;
                String key;
                String s = st.nextToken();
                int pos = s.indexOf(61);
                if (pos >= 0) {
                    key = s.substring(0, pos);
                    val = s.substring(pos + 1);
                } else {
                    key = s;
                    val = "";
                }
                this.params.addParameter(StringUtils.decodeURLIgnorePlus((String)key), StringUtils.decodeURLIgnorePlus((String)val));
            }
        }
    }

    public void resolveHandle() throws HandleException {
        byte[][] types = this.getRequestedTypes();
        int[] indices = null;
        try {
            indices = this.getRequestedIndices();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resolveHandle(types, indices, this.authenticationInfo == null, this.params.getParameter("auth") != null, this.params.getParameter("cert") != null);
        if (this.resResponse != null && this.resResponse.responseCode == 400 && !this.resRequest.ignoreRestrictedValues) {
            this.resolveHandle(types, indices, true, this.resRequest.authoritative, this.resRequest.certify);
        }
    }

    public void resolveHandle(byte[][] types, int[] indices, boolean ignoreRestrictedValues, boolean authoritative, boolean certified) throws HandleException {
        this.resRequest = new ResolutionRequest(Util.encodeString(this.hdl), types, indices, this.authenticationInfo);
        this.resRequest.ignoreRestrictedValues = ignoreRestrictedValues;
        this.resRequest.authoritative = authoritative;
        this.resRequest.certify = certified;
        this.resolutionTime = System.currentTimeMillis();
        this.resResponse = this.resolver.processRequest(this.resRequest, this.getRemoteInetAddress());
    }

    public HandleLocationInfo resolveLocationsViaNamespace(List<String> handles) {
        if (handles == null || handles.isEmpty()) {
            return null;
        }
        HandleLocationInfo res = new HandleLocationInfo();
        boolean found = false;
        for (String handle : handles) {
            HandleLocationInfo locInfo = this.resolveLocationsViaNamespace(handle);
            boolean thisFound = HandleLocationInfo.mergeIntoHandleLocationInfo(res, locInfo);
            found = found || thisFound;
        }
        if (!found) {
            return null;
        }
        return res;
    }

    public HandleLocationInfo resolveLocationsViaNamespace(String handle) {
        boolean auth = this.params.getParameter("auth") != null;
        boolean cert = this.params.getParameter("cert") != null;
        try {
            ResolutionRequest hdlReq = new ResolutionRequest(Util.encodeString(handle), Location.NAMESPACE_TYPES, null, null);
            hdlReq.authoritative = auth;
            hdlReq.certify = cert;
            long nsResolutionTime = System.currentTimeMillis();
            AbstractResponse hdlResp = this.resolver.processRequest(hdlReq, null);
            if (hdlResp instanceof ResolutionResponse) {
                HandleValue[] values;
                for (HandleValue value : values = ((ResolutionResponse)hdlResp).getHandleValues()) {
                    if (!value.hasType(Common.NAMESPACE_INFO_TYPE)) continue;
                    this.modifyExpiration(nsResolutionTime, value);
                }
                NamespaceInfo nsInfo = Util.getNamespaceFromValues(handle, values);
                if (nsInfo == null) {
                    return null;
                }
                List<String> nsHandles = nsInfo.getLocationTemplateHandles();
                if (nsHandles != null) {
                    return this.resolveLocationsForMultipleHandles(nsHandles);
                }
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error resolving namespace for " + handle);
            return null;
        }
    }

    public HandleLocationInfo resolveLocationsForMultipleHandles(List<String> handles) {
        if (handles == null || handles.isEmpty()) {
            return null;
        }
        HandleLocationInfo res = new HandleLocationInfo();
        boolean found = false;
        for (String handle : handles) {
            HandleLocationInfo locInfo = this.resolveLocations(handle);
            boolean thisFound = HandleLocationInfo.mergeIntoHandleLocationInfo(res, locInfo);
            found = found || thisFound;
        }
        if (!found) {
            return null;
        }
        return res;
    }

    private HandleLocationInfo resolveLocations(String handle) {
        boolean auth = this.params.getParameter("auth") != null;
        boolean cert = this.params.getParameter("cert") != null;
        HandleLocationInfo cachedVal = this.thisRequestLocationsCache.get(handle);
        if (cachedVal != null) {
            return cachedVal;
        }
        if (!auth && !cert) {
            cachedVal = locationsCache.get(handle);
        }
        if (cachedVal != null && !cachedVal.isExpired()) {
            if (cachedVal.expirationDate < this.expiration) {
                this.expiration = cachedVal.expirationDate;
            }
            this.thisRequestLocationsCache.put(handle, cachedVal);
            return cachedVal;
        }
        try {
            ResolutionRequest hdlReq = new ResolutionRequest(Util.encodeString(handle), Location.ALL_LOCATION_TYPES, null, null);
            hdlReq.authoritative = auth;
            hdlReq.certify = cert;
            long locResolutionTime = System.currentTimeMillis();
            AbstractResponse hdlResp = this.resolver.processRequest(hdlReq, null);
            if (hdlResp instanceof ResolutionResponse) {
                HandleLocationInfo res = new HandleLocationInfo();
                boolean found = false;
                for (HandleValue value : ((ResolutionResponse)hdlResp).getHandleValues()) {
                    String headersStr;
                    XTag locXML;
                    String locationsStr;
                    if (value.hasType(Location.LOCATION_TYPE)) {
                        locationsStr = Util.decodeString(value.getData());
                        locXML = xmlParser.parse(new StringReader(locationsStr), false);
                        if (locXML == null) continue;
                        this.modifyExpiration(locResolutionTime, value);
                        res.expirationDate = Math.min(res.expirationDate, this.expirationDateFor(locResolutionTime, value));
                        if (res.loc == null) {
                            res.loc = new ArrayList<XTag>();
                        }
                        res.loc.add(locXML);
                        found = true;
                        continue;
                    }
                    if (value.hasType(Location.LINKS_TYPE)) {
                        locationsStr = Util.decodeString(value.getData());
                        locXML = xmlParser.parse(new StringReader(locationsStr), false);
                        if (locXML == null) continue;
                        this.modifyExpiration(locResolutionTime, value);
                        res.expirationDate = Math.min(res.expirationDate, this.expirationDateFor(locResolutionTime, value));
                        if (res.links == null) {
                            res.links = new ArrayList<XTag>();
                        }
                        res.links.add(locXML);
                        found = true;
                        continue;
                    }
                    if (!value.hasType(Location.HEADERS_TYPE) || (headersStr = Util.decodeString(value.getData())) == null) continue;
                    this.modifyExpiration(locResolutionTime, value);
                    res.expirationDate = Math.min(res.expirationDate, this.expirationDateFor(locResolutionTime, value));
                    if (res.headers == null) {
                        res.headers = new ArrayList<String>();
                    }
                    res.headers.add(headersStr);
                    found = true;
                }
                if (found) {
                    this.thisRequestLocationsCache.put(handle, res);
                    locationsCache.put(handle, res);
                    return res;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error resolving locations for " + handle);
            return null;
        }
    }

    public void normalizeHandle() {
        String lowerHdl = this.hdl.toLowerCase();
        if (lowerHdl.startsWith("api/handles/")) {
            this.api = true;
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(12));
            lowerHdl = HDLServletRequest.trimBetter(lowerHdl.substring(12));
        } else if (lowerHdl.startsWith("api/")) {
            this.api = true;
            this.oldApi = true;
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(4));
            lowerHdl = HDLServletRequest.trimBetter(lowerHdl.substring(4));
        }
        if (lowerHdl.startsWith("info:doi/") || lowerHdl.startsWith("info:hdl/")) {
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(9));
        } else if (lowerHdl.startsWith("hdl:") || lowerHdl.startsWith("doi:")) {
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(4));
        } else if (HDLServletRequest.startsWithProxyHttpUri(lowerHdl)) {
            int thirdSlash = HDLServletRequest.findThirdSlash(this.hdl);
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(thirdSlash + 1));
        } else if (lowerHdl.startsWith("urn:hdl:") || lowerHdl.startsWith("urn:doi:") || lowerHdl.startsWith("urn:eidr:")) {
            int colon = this.hdl.indexOf(58, this.hdl.indexOf(58) + 1);
            this.hdl = HDLServletRequest.trimBetter(this.hdl.substring(colon + 1));
            colon = this.hdl.indexOf(58);
            int slash = this.hdl.indexOf(47);
            if (colon >= 0 && (slash < 0 || slash > colon)) {
                this.hdl = this.hdl.substring(0, colon) + "/" + this.hdl.substring(colon + 1);
            }
        }
    }

    static boolean startsWithProxyHttpUri(String s) {
        return proxyHttpUriPattern.matcher(s).lookingAt();
    }

    private static int findThirdSlash(String s) {
        int firstSlash = s.indexOf(47);
        int secondSlash = s.indexOf(47, firstSlash + 1);
        int thirdSlash = s.indexOf(47, secondSlash + 1);
        return thirdSlash;
    }

    public String getReferer() {
        String ref = this.req.getHeader("Referer");
        return ref == null ? "" : ref;
    }

    public List<String> getRequestHeader(String headerName) {
        ArrayList<String> values = new ArrayList<String>();
        Enumeration hvals = this.req.getHeaders(headerName.toString());
        while (hvals.hasMoreElements()) {
            String hval = String.valueOf(hvals.nextElement());
            values.add(hval);
        }
        return values;
    }

    public long getResponseTime() {
        return System.currentTimeMillis() - this.intime;
    }

    private int[] getRequestedIndices() {
        int[] indices = null;
        String[] s = this.params.getParameterValues("index");
        if (s != null) {
            indices = new int[s.length];
            for (int i = 0; i < s.length; ++i) {
                indices[i] = Integer.parseInt(s[i]);
            }
        }
        return indices;
    }

    private byte[][] getRequestedTypes() {
        byte[][] types = null;
        String[] s = this.params.getParameterValues("type");
        if (s != null) {
            types = new byte[s.length][];
            for (int i = 0; i < s.length; ++i) {
                types[i] = Util.encodeString(s[i]);
            }
        }
        return types;
    }

    public String getURLForHandle(String handle) {
        return this.getURLForHandle(handle, "");
    }

    public String getURLForHandle(String handle, String query) {
        String baseURL;
        if (query == null) {
            query = "";
        }
        if ((baseURL = this.servlet.getHandleLinkPrefix(this.req)).endsWith("/") || baseURL.endsWith(":")) {
            return baseURL + StringUtils.encodeURLPath((String)handle) + query;
        }
        return baseURL + "/" + StringUtils.encodeURLPath((String)handle) + query;
    }

    public static String encodeIRIToURI(String location) {
        String lower = location.toLowerCase();
        if (lower.startsWith("http://") || lower.startsWith("https://") || lower.startsWith("ftp://")) {
            int endOfHost;
            int startOfHost = location.indexOf(58) + 3;
            boolean potentialIDN = false;
            int colon = endOfHost = location.length();
            boolean seenAt = false;
            boolean seenColon = false;
            for (int i = startOfHost; i < endOfHost; ++i) {
                char ch = location.charAt(i);
                if (ch >= '\u0080' && !seenColon) {
                    potentialIDN = true;
                    continue;
                }
                if (!seenAt && ch == '@') {
                    seenAt = true;
                    seenColon = false;
                    startOfHost = i + 1;
                    potentialIDN = false;
                    continue;
                }
                if (ch == '/' || ch == '?' || ch == '#') {
                    endOfHost = i;
                    break;
                }
                if (seenColon || ch != ':') continue;
                seenColon = true;
                colon = i;
                if (seenAt) break;
            }
            if (seenColon) {
                endOfHost = colon;
            }
            if (potentialIDN) {
                String host = location.substring(startOfHost, endOfHost);
                try {
                    String encodedHost = IDN.toASCII(host, 1);
                    StringBuilder sb = new StringBuilder(location);
                    sb.replace(startOfHost, endOfHost, encodedHost);
                    return StringUtils.encodeURL((String)sb.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return StringUtils.encodeURL((String)location);
    }

    public void sendHTTPRedirect(ResponseType redirectType, String location) {
        if (this.req.getProtocol().startsWith("HTTP/1.0") && redirectType != ResponseType.MOVED_PERMANENTLY) {
            redirectType = ResponseType.OLD_MOVED_TEMPORARILY;
        }
        if (this.params.getParameter("redirectionHeaders") == null) {
            this.response.setStatus(redirectType.responseCode);
        }
        this.response.setHeader("Location", HDLServletRequest.encodeIRIToURI(location.trim()));
        if (this.getExpiration() < Long.MAX_VALUE) {
            this.response.setDateHeader("Expires", this.getExpiration());
        }
    }

    public void modifyExpiration(HandleValue val) {
        this.modifyExpiration(this.resolutionTime, val);
    }

    public void modifyExpiration(long aResolutionTime, HandleValue val) {
        long newExpiration = this.expirationDateFor(aResolutionTime, val);
        if (newExpiration < this.expiration) {
            this.expiration = newExpiration;
        }
    }

    public long expirationDateFor(long aResolutionTime, HandleValue val) {
        long newExpiration = val.getTTLType() == 1 ? 1000L * (long)val.getTTL() : aResolutionTime + 1000L * (long)val.getTTL();
        newExpiration = Math.min(newExpiration, aResolutionTime + 172800000L);
        return newExpiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteInetAddress;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getUriPathAndParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.encodeURLPath((String)this.hdl));
        boolean first = true;
        for (Map.Entry<String, List<String>> entry : this.params.getMap().entrySet()) {
            String key = entry.getKey();
            for (String val : entry.getValue()) {
                if (first) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                first = false;
                sb.append(StringUtils.encodeURLComponentMinimal((String)key));
                if (val.isEmpty()) continue;
                sb.append("=");
                sb.append(StringUtils.encodeURLComponentMinimal((String)val));
            }
        }
        return sb.toString();
    }

    static {
        SPECIFIC_BROWSER_CONTENT_TYPES.put("text/html", "");
        SPECIFIC_BROWSER_CONTENT_TYPES.put("text/xhtml", "");
        SPECIFIC_BROWSER_CONTENT_TYPES.put("application/xhtml+xml", "");
        SPECIFIC_BROWSER_CONTENT_TYPES.put("application/pdf", "");
        SPECIFIC_BROWSER_CONTENT_TYPES.put("application/vnd.wap.xhtml+xml", "");
        SPECIFIC_BROWSER_CONTENT_TYPES.put("text/vnd.wap.wml", "");
        acceptEntrySorter = (o1, o2) -> {
            float result = o1.quality - o2.quality;
            if (result < 0.0f) {
                return 1;
            }
            if (result > 0.0f) {
                return -1;
            }
            return 0;
        };
        xmlParser = new XParser();
        proxyHttpUriPattern = Pattern.compile("^https?://(?:hdl\\.handle\\.net|(?:dx\\.)?doi\\.org)/");
    }

    public static class AcceptEntry {
        public String value;
        public float quality = 1.0f;

        AcceptEntry(String[] acceptFields) {
            String string = this.value = acceptFields == null || acceptFields.length <= 0 ? "*/*" : acceptFields[0];
            if (this.value != null) {
                this.value = this.value.trim().toLowerCase();
            }
            if (acceptFields != null && acceptFields.length > 1) {
                for (int i = 1; i < acceptFields.length; ++i) {
                    String field = acceptFields[i].trim();
                    if (!field.startsWith("q=")) continue;
                    try {
                        this.quality = Float.parseFloat(field.substring(2));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return "{" + this.value + "; q=" + this.quality + "} (normal=" + AcceptEntry.acceptsBrowserContent(this.value) + ")";
        }

        public static boolean acceptsBrowserContent(String contentType) {
            if (contentType == null) {
                return true;
            }
            if (contentType.indexOf(42) >= 0) {
                return true;
            }
            if (SPECIFIC_BROWSER_CONTENT_TYPES.containsKey(contentType)) {
                return true;
            }
            if (contentType.startsWith("image/")) {
                return true;
            }
            if (contentType.startsWith("audio/")) {
                return true;
            }
            return contentType.startsWith("video/");
        }

        public static boolean hasWildcard(String contentType) {
            return contentType == null || contentType.indexOf(42) >= 0;
        }
    }

    public static class HandleLocationInfo {
        private long expirationDate = System.currentTimeMillis() + 3600000L;
        public List<XTag> loc;
        public List<XTag> links;
        public List<String> headers;

        boolean isExpired() {
            return this.expirationDate <= System.currentTimeMillis();
        }

        public static boolean mergeIntoHandleLocationInfo(HandleLocationInfo res, HandleLocationInfo locInfo) {
            if (locInfo == null) {
                return false;
            }
            boolean found = false;
            if (locInfo.loc != null) {
                if (res.loc == null) {
                    res.loc = new ArrayList<XTag>();
                }
                res.loc.addAll(locInfo.loc);
                found = true;
            }
            if (locInfo.links != null) {
                if (res.links == null) {
                    res.links = new ArrayList<XTag>();
                }
                res.links.addAll(locInfo.links);
                found = true;
            }
            if (locInfo.headers != null) {
                if (res.headers == null) {
                    res.headers = new ArrayList<String>();
                }
                res.headers.addAll(locInfo.headers);
                found = true;
            }
            return found;
        }
    }

    public static enum ResponseType {
        SEE_OTHER(303, "See Other"),
        MOVED_TEMPORARILY(307, "Moved Temporarily"),
        OLD_MOVED_TEMPORARILY(302, "Moved Temporarily"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        NEW_PERMANENT_REDIRECT(308, "Permanent Redirect");

        public static final ResponseType DEFAULT_RESPONSE_TYPE;
        int responseCode;
        String message;

        private ResponseType(int responseCode, String message) {
            this.responseCode = responseCode;
            this.message = message;
        }

        public static ResponseType typeForString(String typeStr) {
            if (typeStr == null) {
                return DEFAULT_RESPONSE_TYPE;
            }
            if (typeStr.equals("")) {
                return DEFAULT_RESPONSE_TYPE;
            }
            if (typeStr.equals("307")) {
                return MOVED_TEMPORARILY;
            }
            if (typeStr.equals("301")) {
                return MOVED_PERMANENTLY;
            }
            if (typeStr.equals("308")) {
                return NEW_PERMANENT_REDIRECT;
            }
            if (typeStr.equals("303")) {
                return SEE_OTHER;
            }
            if (typeStr.equals("302")) {
                return OLD_MOVED_TEMPORARILY;
            }
            return DEFAULT_RESPONSE_TYPE;
        }

        static {
            DEFAULT_RESPONSE_TYPE = OLD_MOVED_TEMPORARILY;
        }
    }
}

