/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import net.cnri.util.DeepClone;
import net.cnri.util.StreamObject;
import net.cnri.util.StreamObjectUtil;
import net.cnri.util.StreamTable;
import net.cnri.util.StringEncodingException;

public class StreamVector
extends Vector<Object>
implements StreamObject {
    @Override
    public boolean isStreamTable() {
        return false;
    }

    @Override
    public boolean isStreamVector() {
        return true;
    }

    public char startingDelimiter() {
        return '(';
    }

    @Override
    public void readFrom(String str) throws StringEncodingException {
        StringReader in = new StringReader(str);
        try {
            this.readFrom(in);
        }
        catch (IOException e) {
            throw new StringEncodingException("IO exception: " + e.toString());
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (Exception exception) {}
        }
    }

    public Object deepClone() {
        StreamVector newVector = new StreamVector();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            try {
                if (item instanceof DeepClone) {
                    item = ((DeepClone)item).deepClone();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception cloning item in StreamVector: " + e);
            }
            newVector.addElement(item);
        }
        return newVector;
    }

    @Override
    public void readFrom(Reader str) throws StringEncodingException, IOException {
        int ch;
        while ((ch = StreamObjectUtil.getNonWhitespace(str)) == 40) {
            this.readTheRest(str);
        }
        if (ch == -1) {
            throw new StringEncodingException("Unexpected end of input in StreamVector.");
        }
        throw new StringEncodingException("Expected (, got '" + (char)ch + "'");
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        this.writeTo(out, 0);
    }

    @Override
    public void writeTo(Writer out, int indentLevel) throws IOException {
        int numSpaces = indentLevel * 2;
        char[] spaces = new char[numSpaces];
        Arrays.fill(spaces, ' ');
        String indentation = new String(spaces);
        out.write("(\n");
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.elementAt(i);
            if (val instanceof StreamObject) {
                ((StreamObject)val).writeTo(out, indentLevel + 1);
                continue;
            }
            out.write(indentation);
            out.write("  ");
            StreamObjectUtil.writeEncodedString(out, String.valueOf(val));
            out.write("\n");
        }
        out.write(indentation);
        out.write(")\n");
    }

    @Override
    public String writeToString() {
        StringWriter out = new StringWriter();
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return out.toString();
    }

    @Override
    public void readTheRest(Reader str) throws StringEncodingException, IOException {
        this.removeAllElements();
        while (true) {
            Object obj;
            int ch = StreamObjectUtil.getNonWhitespace(str);
            switch (ch) {
                case 34: {
                    obj = StreamObjectUtil.readString(str);
                    break;
                }
                case 123: {
                    StreamTable valTable = new StreamTable();
                    valTable.readTheRest(str);
                    obj = valTable;
                    break;
                }
                case 40: {
                    StreamVector vector = new StreamVector();
                    vector.readTheRest(str);
                    obj = vector;
                    break;
                }
                case 41: {
                    return;
                }
                case -1: {
                    throw new StringEncodingException("Unexpected end of input while reading Vector.");
                }
                default: {
                    obj = StreamObjectUtil.readUndelimitedString(str, ch);
                }
            }
            this.addElement(obj);
        }
    }
}

