/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import net.cnri.io.AtomicFile;
import net.cnri.util.DeepClone;
import net.cnri.util.StreamObject;
import net.cnri.util.StreamObjectUtil;
import net.cnri.util.StreamVector;
import net.cnri.util.StringEncodingException;

public class StreamTable
extends Hashtable<String, Object>
implements StreamObject,
DeepClone {
    @Override
    public boolean isStreamTable() {
        return true;
    }

    @Override
    public boolean isStreamVector() {
        return false;
    }

    public char startingDelimiter() {
        return '{';
    }

    public void merge(Hashtable<String, ?> ht) {
        Enumeration<String> e = ht.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            this.put(key, ht.get(key));
        }
    }

    @Override
    public Object deepClone() {
        StreamTable newTable = new StreamTable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.get(key);
            try {
                if (value instanceof DeepClone) {
                    value = ((DeepClone)value).deepClone();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception cloning value in StreamTable: " + ex);
            }
            newTable.put(key, value);
        }
        return newTable;
    }

    public Object get(Object key, Object defaultVal) {
        Object o = super.get(key);
        if (o == null) {
            return defaultVal;
        }
        return o;
    }

    public String getStr(Object key, String defaultVal) {
        Object o = super.get(key);
        if (o == null) {
            return defaultVal;
        }
        return String.valueOf(o);
    }

    public String getStr(Object key) {
        return this.getStr(key, null);
    }

    public boolean getBoolean(Object key, boolean defaultVal) {
        String val = this.getStr(key, defaultVal ? "yes" : "no").toLowerCase();
        if (val.startsWith("y") || val.startsWith("t")) {
            return true;
        }
        if (val.startsWith("n") || val.startsWith("f")) {
            return false;
        }
        return defaultVal;
    }

    public boolean getBoolean(Object key) {
        return this.getBoolean(key, false);
    }

    public long getLong(Object key, long defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(String.valueOf(val));
        }
        catch (Exception e) {
            System.err.println("Invalid long value: " + val);
            return defaultVal;
        }
    }

    public int getInt(Object key, int defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(String.valueOf(val));
        }
        catch (Exception e) {
            System.err.println("Invalid int value: " + val);
            return defaultVal;
        }
    }

    public void readFrom(InputStream in) throws StringEncodingException, IOException {
        this.readFrom(new InputStreamReader(in));
    }

    @Override
    public void readFrom(String str) throws StringEncodingException {
        StringReader in = new StringReader(str);
        try {
            this.readFrom(in);
        }
        catch (IOException e) {
            throw new StringEncodingException("IO exception: " + e.toString());
        }
    }

    @Override
    public void readFrom(Reader str) throws StringEncodingException, IOException {
        int ch = StreamObjectUtil.getNonWhitespace(str);
        if (ch != 123) {
            if (ch == -1) {
                throw new StringEncodingException("Unexpected end of input in StreamTable.");
            }
            throw new StringEncodingException("Expected {, got " + (char)ch);
        }
        this.readTheRest(str);
    }

    public void readFromFile(File file) throws StringEncodingException, IOException {
        AtomicFile atomicFile = new AtomicFile(file, false);
        InputStreamReader in = new InputStreamReader((InputStream)atomicFile.openRead(), "UTF-8");
        this.readFrom(in);
        ((Reader)in).close();
    }

    public String[] getStringKeys() {
        return this.keySet().toArray(new String[0]);
    }

    public void readFromFile(String fileName) throws StringEncodingException, IOException {
        this.readFromFile(new File(fileName));
    }

    public void writeToFile(String fileName) throws IOException {
        this.writeToFile(fileName, true);
    }

    public void writeToFile(String fileName, boolean sync) throws IOException {
        this.writeToFile(new File(fileName), sync);
    }

    public void writeToFile(File file) throws IOException {
        this.writeToFile(file, true);
    }

    public void writeToFile(File file, boolean sync) throws IOException {
        AtomicFile atomicFile = new AtomicFile(file, sync);
        FileOutputStream outStream = atomicFile.startWrite();
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            this.writeTo(out);
            ((Writer)out).flush();
            atomicFile.finishWrite(outStream);
        }
        catch (IOException e) {
            atomicFile.failWrite(outStream);
            throw e;
        }
    }

    @Override
    public void readTheRest(Reader str) throws StringEncodingException, IOException {
        this.clear();
        while (true) {
            Object obj;
            String key;
            int ch;
            if ((ch = StreamObjectUtil.getNonWhitespace(str)) == 34) {
                key = StreamObjectUtil.readString(str);
            } else {
                if (ch == 125) {
                    return;
                }
                if (ch == -1) {
                    throw new StringEncodingException("Unexpected end of input in StreamTable.");
                }
                key = StreamObjectUtil.readUndelimitedString(str, ch);
            }
            ch = StreamObjectUtil.getNonWhitespace(str);
            if (ch != 61) {
                throw new StringEncodingException("Expected \"=\" ");
            }
            ch = StreamObjectUtil.getNonWhitespace(str);
            if (ch == 34) {
                obj = StreamObjectUtil.readString(str);
            } else if (ch == 123) {
                StreamTable valTable = new StreamTable();
                valTable.readTheRest(str);
                obj = valTable;
            } else if (ch == 40) {
                StreamVector vector = new StreamVector();
                vector.readTheRest(str);
                obj = vector;
            } else {
                if (ch == -1) {
                    throw new StringEncodingException("Unexpected end of input: Expected value for key: '" + key + "'");
                }
                obj = StreamObjectUtil.readUndelimitedString(str, ch);
            }
            this.put(key, obj);
        }
    }

    @Override
    public void put(String key, boolean boolVal) {
        this.put(key, boolVal ? "yes" : "no");
    }

    @Override
    public void put(String key, int intVal) {
        this.put(key, String.valueOf(intVal));
    }

    @Override
    public void put(String key, long longVal) {
        this.put(key, String.valueOf(longVal));
    }

    @Override
    public synchronized String toString() {
        return this.writeToString();
    }

    @Override
    public String writeToString() {
        StringWriter out = new StringWriter();
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return out.toString();
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        this.writeTo(out, 0);
    }

    @Override
    public void writeTo(Writer out, int indentLevel) throws IOException {
        int numSpaces = indentLevel * 2;
        char[] spaces = new char[numSpaces];
        Arrays.fill(spaces, ' ');
        String indentation = new String(spaces);
        out.write("{\n");
        Enumeration en = this.keys();
        while (en.hasMoreElements()) {
            out.write(indentation);
            out.write("  ");
            String key = (String)en.nextElement();
            StreamObjectUtil.writeEncodedString(out, key);
            out.write(" = ");
            Object val = this.get(key);
            if (val instanceof StreamObject) {
                ((StreamObject)val).writeTo(out, indentLevel + 1);
            } else {
                StreamObjectUtil.writeEncodedString(out, String.valueOf(val));
            }
            out.write("\n");
        }
        out.write(indentation);
        out.write("}\n");
    }
}

