/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

public abstract class XUtil {
    public static final String encodeString(String str) {
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                sb.append("&#39;");
                continue;
            }
            if (ch >= '\u00ff') {
                sb.append("&#");
                sb.append((int)ch);
                sb.append(';');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String decodeString(String str) {
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                String entity = XUtil.readEntity(str, i);
                i += entity.length() - 1;
                sb.append(XUtil.decodeEntity(entity));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String decodeEntity(String entity) {
        String upper = entity.toUpperCase();
        if (upper.equals("&AMP;")) {
            return "&";
        }
        if (upper.equals("&LT;")) {
            return "<";
        }
        if (upper.equals("&GT;")) {
            return ">";
        }
        if (upper.equals("&QUOT;")) {
            return "\"";
        }
        if (upper.equals("&APOS;")) {
            return "'";
        }
        if (upper.startsWith("&#X")) {
            try {
                return String.valueOf(Character.toChars(Integer.parseInt(entity.substring(3, entity.length() - 1), 16)));
            }
            catch (Exception exception) {
            }
        } else if (entity.startsWith("&#")) {
            try {
                return String.valueOf(Character.toChars(Integer.parseInt(entity.substring(2, entity.length() - 1))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entity;
    }

    private static String readEntity(String str, int index) {
        int eIndex;
        for (eIndex = index + 1; eIndex < str.length() && str.charAt(eIndex) != ';'; ++eIndex) {
        }
        eIndex = Math.min(str.length() - 1, eIndex);
        return str.substring(index, eIndex + 1);
    }
}

