/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cnri.simplexml.XUtil;

public class XTag {
    private final String name;
    private Object value;
    private ArrayList<XTag> subTags = null;
    private HashMap<String, String> attributes = null;
    private boolean suppressNewLine = false;

    public XTag(String name, Object value) {
        this.name = name.trim();
        this.value = value != null && value instanceof String ? ((String)value).trim() : value;
    }

    public XTag(String name) {
        this.name = name;
        this.value = null;
    }

    public XTag shallowCloneTag() {
        XTag cloneTag = new XTag(this.name, this.value);
        for (String attributeKey : this.attributes.keySet()) {
            cloneTag.setAttribute(attributeKey, this.attributes.get(attributeKey));
        }
        return cloneTag;
    }

    public boolean isContainer() {
        return this.value == null;
    }

    public void addSubTag(XTag subTagValue) {
        this.value = null;
        if (this.subTags == null) {
            this.subTags = new ArrayList();
        }
        this.subTags.add(subTagValue);
    }

    public int getSubTagCount() {
        if (this.subTags == null) {
            return 0;
        }
        return this.subTags.size();
    }

    public XTag getSubTag(int i) {
        if (this.subTags == null) {
            return null;
        }
        if (i < 0 || i >= this.subTags.size()) {
            return null;
        }
        return this.subTags.get(i);
    }

    public XTag getSubTag(String tagName) {
        if (this.subTags == null) {
            return null;
        }
        for (int i = 0; i < this.subTags.size(); ++i) {
            XTag subtag = this.subTags.get(i);
            if (!subtag.getName().equals(tagName)) continue;
            return subtag;
        }
        return null;
    }

    public XTag removeSubTag(int index) {
        if (index < 0 || index >= this.subTags.size()) {
            return null;
        }
        XTag rmTag = this.getSubTag(index);
        this.subTags.remove(index);
        return rmTag;
    }

    public List<XTag> getSubTags() {
        return this.subTags;
    }

    public boolean removeSubTag(XTag subtag) {
        if (subtag == null) {
            return false;
        }
        return this.subTags.remove(subtag);
    }

    public boolean hasSubTag(String tagName) {
        if (this.subTags == null) {
            return false;
        }
        for (XTag subtag : this.subTags) {
            if (!subtag.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public void setSuppressNewLine(boolean suppressNewLine) {
        this.suppressNewLine = suppressNewLine;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStrValue() {
        return String.valueOf(this.getValue());
    }

    public int getIntValue() throws Exception {
        return Integer.parseInt(this.getStrValue().trim());
    }

    public long getLongValue() throws Exception {
        return Long.parseLong(this.getStrValue().trim());
    }

    public double getDoubleValue() throws Exception {
        return Double.parseDouble(this.getStrValue().trim());
    }

    public URL getUrlValue() throws Exception {
        return new URL(this.getStrValue());
    }

    public boolean getBoolValue() {
        return this.getStrValue().toUpperCase().trim().startsWith("Y");
    }

    public boolean getBoolSubTag(String tagName, boolean defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getBoolValue();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public String getStrSubTag(String tagName, String defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        return subtag.getStrValue();
    }

    public int getIntSubTag(String tagName, int defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getIntValue();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public long getLongSubTag(String tagName, long defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getLongValue();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public double getDoubleSubTag(String tagName, double defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getDoubleValue();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public URL getUrlSubTag(String tagName, URL defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getUrlValue();
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public String[] getStrListSubTag(String tagName) {
        if (this.subTags == null) {
            return new String[0];
        }
        ArrayList<String> strVect = new ArrayList<String>();
        for (XTag subtag : this.subTags) {
            if (!subtag.getName().equals(tagName)) continue;
            strVect.add(subtag.getStrValue());
        }
        return strVect.toArray(new String[strVect.size()]);
    }

    public void setValue(String value) {
        this.value = value;
    }

    void setAttributes(HashMap<String, String> newAttributes) {
        if (newAttributes == null || newAttributes.size() <= 0) {
            this.attributes = null;
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            } else {
                this.attributes.clear();
            }
            this.attributes.putAll(newAttributes);
        }
    }

    public void setAttribute(String name, String val) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, val);
    }

    public void setAttribute(String name, boolean val) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, val ? "yes" : "no");
    }

    public void setAttribute(String name, int val) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, String.valueOf(val));
    }

    public String getAttribute(String attrName, String defaultVal) {
        String val = this.getAttribute(attrName);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public String getAttribute(String attrName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    public boolean getBoolAttribute(String attrName, boolean defaultVal) {
        String val = this.getAttribute(attrName);
        if (val == null) {
            return defaultVal;
        }
        if ((val = val.toLowerCase()).equals("yes") || val.equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("no") || val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultVal;
    }

    public String getStrAttribute(String tagName, String defaultVal) {
        return this.getAttribute(tagName, defaultVal);
    }

    public int getIntAttribute(String attrName, int defaultVal) {
        String val = this.getAttribute(attrName);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public long getLongAttribute(String attrName, long defaultVal) {
        String val = this.getAttribute(attrName);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(val.trim());
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public double getDoubleAttribute(String attrName, double defaultVal) {
        String val = this.getAttribute(attrName);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(val.trim());
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF8");
        this.write(w);
        w.flush();
    }

    public void write(Writer out) throws IOException {
        this.write(out, true, "");
    }

    public void write(Writer out, boolean pretty, String prefix) throws IOException {
        String valueStr = this.value == null ? null : String.valueOf(this.value);
        boolean emptyValue = this.getSubTagCount() <= 0 && (valueStr == null || valueStr.length() <= 0);
        out.write("<");
        String tagName = XUtil.encodeString(this.name);
        out.write(tagName);
        HashMap<String, String> atts = this.attributes;
        if (atts != null) {
            for (String key : atts.keySet()) {
                String val = atts.get(key);
                out.write(" ");
                out.write(XUtil.encodeString(key));
                out.write("=\"");
                out.write(XUtil.encodeString(val));
                out.write("\"");
            }
        }
        if (emptyValue) {
            out.write("/");
        }
        out.write(">");
        if (!emptyValue && this.getSubTagCount() <= 0) {
            out.write(XUtil.encodeString(valueStr));
        } else if (this.getSubTagCount() > 0) {
            if (pretty) {
                out.write("\n");
            }
            for (int i = 0; i < this.subTags.size(); ++i) {
                this.subTags.get(i).write(out, pretty, pretty ? prefix + "  " : "");
            }
        }
        if (!emptyValue) {
            out.write("</");
            out.write(tagName);
            out.write(">");
        }
        if (pretty && !this.suppressNewLine) {
            out.write("\n");
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.write(w, true, "");
        }
        catch (Exception e) {
            System.err.println("Error encoding tags: " + e);
            e.printStackTrace(System.err);
        }
        return w.toString();
    }
}

