/**********************************************************************\
 © COPYRIGHT 2018 Corporation for National Research Initiatives (CNRI);
                        All rights reserved.

        The HANDLE.NET software is made available subject to the
      Handle.Net Public License Agreement, which may be obtained at
          http://hdl.handle.net/20.1000/112 or hdl:20.1000/112
\**********************************************************************/

package net.handle.server;

import java.util.Hashtable;
import java.util.Vector;

import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@SuppressWarnings({"rawtypes", "unchecked"})
public class SigarWrapper {
    private final Sigar sig = new Sigar();

    public boolean isReady() {
        return sig.getNativeLibrary() != null;
    }

    public String getFQDN() throws SigarException {
        return sig.getFQDN();
    }

    public Vector getDiskInfo() throws SigarException {
        Vector diskInfoVector = new Vector();

        FileSystem[] fsystems = sig.getFileSystemList();

        for (FileSystem currentSystem : fsystems) {
            Hashtable diskInfo = new Hashtable();
            String devName = currentSystem.getDevName();
            String dirName = currentSystem.getDirName();
            FileSystemUsage currentSystemUsage = sig.getFileSystemUsage(dirName);
            String name = devName + ":" + dirName;
            double diskQueue = currentSystemUsage.getDiskQueue();
            long freeBytes = currentSystemUsage.getFree();
            long usedBytes = currentSystemUsage.getUsed();

            diskInfo.put("name", name);
            diskInfo.put("queue", fixDoubleForJson(diskQueue));
            diskInfo.put("free", freeBytes);
            diskInfo.put("used", usedBytes);

            diskInfoVector.add(diskInfo);

        }

        return diskInfoVector;
    }

    private double fixDoubleForJson(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) return -1;
        return d;
    }

    public Hashtable getMemInfo() throws SigarException {
        Hashtable memInfo = new Hashtable();
        Mem mem = sig.getMem();
        memInfo.put("used", mem.getActualUsed());
        memInfo.put("free", mem.getActualFree());
        return memInfo;
    }

    public Vector getLoadAverageInfo() throws SigarException {
        // Put the load averate into an array to play nicer with gson.
        Vector loadAverageInfo = new Vector();
        double[] laArray = sig.getLoadAverage();

        for (int i = 0; i < 3; i++) {
            loadAverageInfo.add(fixDoubleForJson(laArray[i]));
        }

        return loadAverageInfo;
    }

}
